block('b-strategy2-settings').elem('roi-value-hint').content()(function() {
    var roiValue = parseFloat(this.ctx.roi);

    if (isNaN(roiValue)) {
        return '';
    }

    var BIG_ROI_COEF_VALUE = 20,
        currency = this.ctx.currency,
        roiPercentValue = roiValue * 100,
        budgetValue = 1000,
        profitValue = budgetValue * roiValue,
        incomeValue = budgetValue + profitValue;

    return {
        block: 'b-warning-message',
        mods: {
            theme: 'info'
        },
        mix: [
            {
                block: 'b-strategy2-settings',
                elem: 'roi-value-hint'
            }
        ],
        content: [
            roiValue > BIG_ROI_COEF_VALUE && {
                block: 'b-strategy2-settings',
                elem: 'roi-value-hint-title',
                content: iget2(
                    'b-strategy2-settings',
                    'roi-value-hint-title',
                    'Внимание! Задан высокий целевой ROI')
            },
            {
                block: 'b-strategy2-settings',
                elem: 'roi-value-hint-text',
                content: iget2(
                    'b-strategy2-settings',
                    'roi-value-hint-text',
                    'Задан {roiValue} — что соответсвует {roiPersentValue} % рентабельности. При вложении в рекламу, например, {budgetValue} вы ожидаете доход {incomeValue} и прибыль {profitValue}',
                    {
                        roiValue: {
                            block: 'b-strategy2-settings',
                            elem: 'roi-value-hint-text-attent',
                            content: 'ROI = ' + roiValue
                        },
                        roiPersentValue: u.numberFormatter.format(roiPercentValue, { precision: 0 }),
                        budgetValue: u.currencies.formatSum(currency, budgetValue),
                        profitValue: u.currencies.formatSum(currency, profitValue),
                        incomeValue: u.currencies.formatSum(currency, incomeValue)
                    }
                )
            }
        ]
    };
});
