block('b-strategy2-settings').elem('row').elemMod('type', 'budget').content()(function() {
    var ctx = this.ctx,
        isPeriod = ctx.spendMode === 'period';

    return [
        {
            elem: 'label',
            content: iget2('b-strategy2-settings', 'label-budget', 'Бюджет')
        },
        {
            elem: 'control-wrap',
            content: u.spacer2([
                {
                    block: 'b-strategy2-settings',
                    elem: 'coverage-control-input',
                    elemMods: { type: ctx.spendMode },
                    value: ctx.budget,
                    field: ctx.field
                },
                {
                    elem: 'currency',
                    content: u.formatCurrency(ctx.currency)
                },
                isPeriod && {
                    elem: 'period',
                    period_range: ctx.period_range
                }
            ])
        }
    ]
});

block('b-strategy2-settings').elem('period').content()(function() {
    var periodRange = this.ctx.period_range;

    return u.pluralizeWord([
        iget2('b-strategy2-settings', 'na-period-den', 'на {days} день', { days: periodRange }),
        iget2('b-strategy2-settings', 'na-period-dnya', 'на {days} дня', { days: periodRange }),
        iget2('b-strategy2-settings', 'na-period-dney', 'на {days} дней', { days: periodRange })
    ], periodRange);
});
