block('b-strategy2-settings').elem('row').elemMod('type', 'price').content()(function() {
    var ctx = this.ctx,
        isAvgCpv = this.modelData.isAvgCpv,
        labelText = {
            elem: 'label',
            content: iget2('b-strategy2-settings', 'label-cena-za-tysjachu-pokazov', 'Средняя цена не более')
        },
        labelAvgCpv = {
            elem: 'label',
            content: iget2('b-strategy2-settings', 'label-cena', 'Средняя цена')
        },
        resInput = {
            input: {
                block: 'b-strategy2-settings',
                elem: 'coverage-control-input',
                elemMods: { type: ctx.spendMode },
                value: ctx.value,
                field: ctx.field
            },
            currency: {
                elem: 'currency',
                content: u.formatCurrency(ctx.currency)
            },
            context: 'input - инпут ввода ставки, currency - валюта'
        },
        label = labelText;

    if (ctx.mediaType === 'cpm_yndx_frontpage') {
        label = {
            elem: 'label-wrap',
            content: [
                labelText,
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    mix: [{
                        block: 'b-strategy2-settings',
                        elem: 'help-icon'
                    }],
                    url: u.getHelpUrl('cpm-frontpage-maximum-bid')
                }
            ]
        };
    }

    return [
        isAvgCpv ? labelAvgCpv : label,
        {
            elem: 'control-wrap',
            content: isAvgCpv ? iget2(
                'b-strategy2-settings',
                'control-sr-cena-za-prosmotr',
                '{input} {currency} за просмотр',
                resInput
            ) : iget2(
                'b-strategy2-settings',
                'control-sr-cena-za-tysjachu-pokazov',
                '{input} {currency} за тысячу показов',
                resInput
            )
        }
    ]
});
