block('b-strategy2-settings').elem('row').elemMod('type', 'recommendation').content()(function() {
    var ctx = this.ctx;

    return [
        {
            elem: 'label-wrap',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-strategy2-settings', 'price-recommendation', 'Рекомендация цены')
                },
                {
                    block: 'b-help-link',
                    mods: { type: 'modal' },
                    stretched: true,
                    mix: [{
                        block: 'b-strategy2-settings',
                        elem: 'help-icon'
                    }],
                    url: u.getHelpUrl('cpm-recommended-value')
                }
            ]
        },
        {
            elem: 'recommendation-price',
            elemMods: {
                type: ctx.spendMode
            },
            mix: {
                elem: 'control-wrap'
            },
            content: ctx.cid ?
                [
                    {
                        elem: 'price',
                        elemMods: {
                            mode: ctx.spendMode,
                            hidden: 'yes'
                        }
                    },
                    {
                        block: 'button',
                        mix: {
                            block: 'b-strategy2-settings',
                            elem: 'coverage-control-button'
                        },
                        mods: { disabled: 'yes', theme: 'action' },
                        content: iget2('b-strategy2-choose', 'set-recommendation-price', 'Установить рекомендованную цену'),
                    },
                    {
                        elem: 'notification-price',
                        elemMods: {
                            hidden: 'yes',
                            mode: ctx.spendMode
                        },
                        content: iget2('b-strategy2-settings', 'current-price-is-same-recommendation', 'Установленная цена не отличается от рекомендуемой'),
                    }
                ] :
                [
                    {
                        block: 'radiobox',
                        mods: { disabled: 'yes' },
                        mix: [{
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: ctx.spendMode === 'week' ? 'coverageWeekMode' : 'coveragePeriodMode',
                                type: 'radiobox'
                            }
                        }],
                        value: ctx.spendMode === 'week' ? ctx.coverageWeekMode : ctx.coveragePeriodMode,
                        content: [
                            {
                                elem: 'radio',
                                mix: {
                                    block: 'b-strategy2-settings',
                                    elem: 'radiobox-item'
                                },
                                controlAttrs: { value: 'wide' },
                                content: iget2('b-strategy2-settings', 'wide-coverage', 'широкий охват')
                            },
                            {
                                elem: 'radio',
                                mix: {
                                    block: 'b-strategy2-settings',
                                    elem: 'radiobox-item'
                                },
                                controlAttrs: { value: 'narrow' },
                                content: iget2('b-strategy2-settings', 'narrow-coverage', 'узкий охват')
                            }
                        ]
                    }
                ]
        }
    ]
});
