block('b-strategy2-settings').elem('row').elemMod('type', 'slider').content()(function() {
    var ctx = this.ctx;

    return [
        {
            elem: 'label-wrap',
            content: [
                {
                    elem: 'label',
                    content: iget2('b-strategy2-settings', 'forecast', 'Прогноз')
                },
                {
                    block: 'b-help-link',
                    mix: [
                        {
                            block: 'b-hintable-popup',
                            js: {
                                hint: {
                                    block: 'b-strategy2-settings',
                                    elem: 'help-forecast-content',
                                    requestId: ctx.requestId
                                },
                                directions: ['bottom'],
                                onScroll: 'close'
                            }
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'forecast-hint',
                            elemMods: {
                                type: ctx.spendMode
                            },
                        }
                    ]
                }
            ]
        },
        {
            elem: 'control-wrap',
            content: [
                {
                    elem: 'slider',
                    elemMods: {
                        type: ctx.spendMode
                    },
                    currency: ctx.currency,
                    value: ctx.value,
                    minAutobudgetAvgCpm: ctx.minAutobudgetAvgCpm
                }
            ]
        }
    ]
});

block('b-strategy2-settings').elem('slider').replace()(function() {
    var currency = this.ctx.currency,
        slider = {
            step: 0.01, // шаг
            rupture: 70 // шкала основных значений - 70%, на конечных 30% располагаются оставшиеся значения
        },
        isAvgCpv = this.modelData.isAvgCpv,
        minCpmPrice = isAvgCpv ?
            u.currencies.getConst(currency, 'MIN_AVG_CPV') :
            u.currencies.getConst(currency, 'MIN_AUTOBUDGET_AVG_CPM'),
        min = this.ctx.minAutobudgetAvgCpm || minCpmPrice,
        maxCpmPrice = isAvgCpv ?
            u.currencies.getConst(currency, 'MAX_AVG_CPV') :
            u.currencies.getConst(currency, 'MAX_CPM_PRICE'),
        // граница основных значений, под ней будет подсказка сумма + валюта
        max = isAvgCpv ?
            u.currencies.getConst(currency, 'MIDDLE_AVG_CPV') :
            this.ctx.minAutobudgetAvgCpm > minCpmPrice ?
                // Если переданное мин. значение больше константного, сдвигаем границу основных значений
                maxCpmPrice / 6 :
                maxCpmPrice / 10;

    return {
        block: 'slider',
        mods: {
            orientation: 'horiz',
            gradient: 'cpm-strategy'
        },
        mix: {
            block: 'b-strategy2-settings',
            elem: 'slider',
            elemMods: this.ctx.elemMods
        },
        js: {
            min: min,
            max: max,
            scale: [
                {
                    value: min,
                    label: u.numberFormatter.format(min),
                    step: slider.step
                },
                {
                    value: max,
                    label: u.numberFormatter.format(max),
                    step: slider.step,
                    percent: slider.rupture
                },
                {
                    value: maxCpmPrice,
                    label: u.numberFormatter.format(maxCpmPrice),
                    step: slider.step
                }
            ]
        },
        extendContent: false,
        content: {
            elem: 'info',
            content: [
                {
                    block: 'textinput',
                    mix: {
                        block: this.block,
                        elem: 'slider-input'
                    },
                    text: this.ctx.value
                },
                {
                    elem: 'body',
                    content: [
                        {
                            elem: 'gradient',
                            mix: {
                                block: this.block,
                                elem: 'slider-gradient'
                            }
                        },
                        { elem: 'click' }
                    ]
                }
            ]
        }
    };
});
