/**
 * Элемент "недельный бюджет"
 * @param {Boolean} ctx.weekBid – недельный бюджет
 * @param {Boolean} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('week-bid-control-2').replace()(function() {
    var ctx = this.ctx,
        weekBid = ctx.weekBid,
        currency = ctx.currency;

    return {
        elem: 'row',
        mix: {
            elem: 'week-bid-control-2'
        },
        content: iget2('b-strategy2-settings', 'spend-tratit-input-week', '{spend} {input} {week}', {
            spend: function(text) {
                return {
                    elem: 'label',
                    content: text + '&nbsp;'
                };
            }(iget2('b-strategy2-settings', 'spend-tratit-input-week-param-spend', 'Тратить')),

            input: function() {
                return {
                    block: 'input',
                    mods: { clear: 'no' },
                    mix: [
                        {
                            block: 'b-hintable',
                            js: true
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: 'weekBid',
                                type: 'formatted-input'
                            }
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'week-bid-input'
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'prevalidate-input',
                            js: {
                                highValue: u.currencies.getConst(currency, 'AUTOBUDGET_SUM_WARNING'),
                                modelField: 'weekBid'
                            }
                        }
                    ],
                    value: weekBid ?
                        u.numberFormatter.roundFormatted(weekBid, {
                            precision: 2,
                            fail: ''
                        }) :
                        '',
                    content: { elem: 'control' }
                };
            }(),

            week: function(text) {
                return {
                    elem: 'label',
                    content: '&nbsp;' + u.currencies.getName(currency) + '&nbsp;' + text
                };
            }(iget2('b-strategy2-settings', 'spend-tratit-input-week-param-week', 'в неделю')),

            context: 'spend - Тратить; week - в неделю'
        })
    };
});
