/**
 * Элемент "Уточнить недельный бюджет"
 * @param {Boolean} ctx.weekBidEnabled – установлен ли недельный бюджет
 * @param {Number} ctx.weekBid – ставка недельного бюджета
 * @param {String} ctx.labelText – текст для лейбла чекбокса
 */
block('b-strategy2-settings').elem('week-bid-control')(
    elem('week-bid-control-itself').replace()(function() {
        var ctx = this.ctx,
            isReadOnly = ctx.isReadOnly,
            weekBid = ctx.weekBid,
            currency = ctx.currency;

        return [
            {
                block: 'input',
                mods: {
                    clear: 'no',
                    disabled: isReadOnly ? 'yes' : ''
                },
                mix: [
                    {
                        block: 'b-hintable',
                        js: true
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'model-field',
                        js: {
                            name: 'weekBid',
                            type: 'formatted-input'
                        }
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'input-control',
                        elemMods: { field: 'weekBid' }
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'prevalidate-input',
                        js: {
                            highValue: u.currencies.getConst(currency, 'AUTOBUDGET_SUM_WARNING'),
                            modelField: 'weekBid'
                        }
                    }
                ],
                value: weekBid ?
                    u.numberFormatter.roundFormatted(weekBid, {
                        precision: 2,
                        fail: ''
                    }) : '',
                content: { elem: 'control' }
            },
            '&nbsp;' + u.currencies.getName(currency)
        ];
    }),

    replace()(function() {
        var ctx = this.ctx,
            weekBidEnabled = ctx.weekBidEnabled,
            weekBid = ctx.weekBid,
            isReadOnly = ctx.isReadOnly,
            currency = ctx.currency,
            labelText = ctx.labelText || iget2('b-strategy2-settings', 'utochnit-nedelnyy-byudzhet', 'Уточнить недельный бюджет');

        return {
            elem: 'row',
            mix: [
                {
                    block: 'b-strategy2-settings',
                    elem: 'week-bid-control'
                },
                { elem: 'week-bid-control' }
            ],
            elemMods: { collapsed: weekBidEnabled ? '' : 'yes' },
            content: [
                {
                    block: 'checkbox',
                    mods: { checked: weekBidEnabled ? 'yes' : '' },
                    mix: [
                        {
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: 'weekBidEnabled',
                                type: 'checkbox'
                            }
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'toggle-row'
                        }, {
                            block: 'b-strategy2-settings',
                            elem: 'week-bid-control-toggle'
                        }
                    ],
                    text: labelText
                },
                '&nbsp;',
                {
                    elem: 'collapsing-area',
                    content: {
                        elem: 'week-bid-control-itself',
                        isReadOnly: isReadOnly,
                        weekBid: weekBid,
                        currency: currency
                    }
                }
            ]
        };
    }),

    elemMod('collapsible', 'no')(
        replace()(function() {
            var ctx = this.ctx,
                weekBid = ctx.weekBid,
                isReadOnly = ctx.isReadOnly,
                currency = ctx.currency;

            return {
                elem: 'row',
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'week-bid-control'
                    }
                ],
                content: [
                    iget2('b-strategy2-settings', 'with-week-budget-limit', 'При ограничении недельного бюджета'),
                    '&nbsp;',
                    {
                        elem: 'week-bid-control-itself',
                        isReadOnly: isReadOnly,
                        weekBid: weekBid,
                        currency: currency
                    }
                ]
            };
        })
    )
);
