/**
 * Элемент "недельный пакет кликов"
 * @param {Boolean} ctx.clickBidEnabled – включено ли уточнение цены клика
 * @param {Boolean} ctx.clickBidType – тип цены клика
 * @param {Boolean} ctx.clickBid – цена клика
 * @param {Boolean} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('week-bundle-click-bid').replace()(function() {
    var ctx = this.ctx,
        clickBidEnabled = ctx.clickBidEnabled,
        clickBidType = ctx.clickBidType,
        clickBid = ctx.clickBid,
        currency = ctx.currency;

    return {
        elem: 'row',
        elemMods: { collapsed: clickBidEnabled ? '' : 'yes' },
        mix: {
            elem: 'week-bundle-click-bid'
        },
        content: [
            {
                block: 'checkbox',
                mods: { checked: clickBidEnabled ? 'yes' : '' },
                mix: [
                    {
                        block: 'b-strategy2-settings',
                        elem: 'model-field',
                        js: {
                            name: 'clickBidEnabled',
                            type: 'checkbox'
                        }
                    },
                    {
                        block: 'b-strategy2-settings',
                        elem: 'toggle-row'
                    }
                ],
                text: iget2('b-strategy2-settings', 'utochnit-cenu-klika', 'Уточнить цену клика')
            },
            '&nbsp;',
            {
                elem: 'collapsing-area',
                content: [
                    {
                        block: 'select',
                        mix: [
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'clickBidType',
                                    type: 'select'
                                }
                            }
                        ],
                        content: [
                            { block: 'button' },
                            {
                                elem: 'control',
                                content: [
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'max',
                                            selected: clickBidType === 'max' ? 'selected' : undefined
                                        },
                                        content: iget2('b-strategy2-settings', 'maksimalnaya', 'максимальная')
                                    },
                                    {
                                        elem: 'option',
                                        attrs: {
                                            value: 'avg',
                                            selected: clickBidType === 'avg' ? 'selected' : undefined
                                        },
                                        content: iget2('b-strategy2-settings', 'srednyaya-za-nedelyu', 'средняя за неделю')
                                    }
                                ]
                            }
                        ]
                    },
                    '&nbsp;',
                    iget2('b-strategy2-settings', 'ne-bolee', 'не более'),
                    '&nbsp;',
                    {
                        block: 'input',
                        mods: { clear: 'no' },
                        mix: [
                            {
                                block: 'b-hintable',
                                js: true
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'clickBid',
                                    type: 'formatted-input'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'prevalidate-input',
                                js: {
                                    highValue: u.currencies.getConst(currency, 'AUTOBUDGET_MAX_PRICE_WARNING'),
                                    modelField: 'clickBid'
                                }
                            }
                        ],
                        value: clickBid ?
                            u.numberFormatter.roundFormatted(clickBid, {
                                precision: 2,
                                fail: ''
                            }) :
                            '',
                        content: { elem: 'control' }
                    },
                    '&nbsp;' + this.currency
                ]
            }
        ]
    };
});
