/**
 * Элемент "недельный пакет кликов"
 * @param {Boolean} ctx.clicksLimit – количество кликов
 * @param {Boolean} ctx.currency – код валюты
 */
block('b-strategy2-settings').elem('week-bundle-control').replace()(function() {
    var ctx = this.ctx,
        clicksLimit = ctx.clicksLimit,
        currency = ctx.currency;

    return {
        elem: 'row',
        mix: [
            {
                block: 'b-strategy2-settings',
                elem: 'week-bundle-control'
            }
        ],
        content: iget2('b-strategy2-settings', 'get-poluchat-input-clicks', '{get} {input} {clicks}', {
            get: function(text) {
                return {
                    elem: 'label',
                    content: text + '&nbsp;'
                };
            }(iget2('b-strategy2-settings', 'get-poluchat-input-clicks-param-get', 'Получать')),

            input: function() {
                return {
                    block: 'input',
                    mods: { clear: 'no' },
                    mix: [
                        {
                            block: 'b-hintable',
                            js: true
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: 'clicksLimit',
                                type: 'formatted-input'
                            }
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'clicks-limit-input'
                        },
                        {
                            block: 'b-strategy2-settings',
                            elem: 'prevalidate-input',
                            js: {
                                highValue: u.currencies.getConst(currency, 'AUTOBUDGET_CLICKS_BUNDLE_WARNING'),
                                modelField: 'clicksLimit'
                            }
                        }
                    ],
                    value: clicksLimit ?
                        u.numberFormatter.roundFormatted(clicksLimit, {
                            precision: 0,
                            fail: ''
                        }) :
                        '',
                    content: { elem: 'control' }
                };
            }(),

            clicks: function(text) {
                return {
                    elem: 'label',
                    mix: [{ elem: 'limit-clicks' }],
                    content: '&nbsp;' + text
                };
            }(iget2('b-strategy2-settings', 'get-poluchat-input-clicks-param-clicks', 'кликов в неделю')),

            context: 'get - Получать; clicks - кликов в неделю'
        })
    };
});
