/**
 * Базовая модель панели настройки стратегий 'Оптимизация количества кликов' и 'Оптимизация количества конверсий'
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_media-type_performance', baseModel: 'b-strategy2-settings' }, {
    /**
     * Сущности на которую нацелена стратегия (кампания или фильтр)
     */
    target: {
        type: 'enum',
        'default': 'filter',
        'enum':['camp', 'filter']
    },

    /**
     * ID цели в метрике
     */
    goalId: 'string',

    /**
     * Название стратегии на серверной стороне
     */
    originName: 'string',

    /**
     * Является ли кампания новой
     */
    isNewCamp: 'boolean',

    /**
     * Уточнение максимальной цены клика
     */
    maxClickBidEnabled: 'boolean',

    /**
     * Уточнение недельного бюджета
     */
    weekBidEnabled: 'boolean',

    /**
     * Недельный бюджет
     */
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('weekBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                lowerClickPrice: {
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt', 'Недельный бюджет должен быть больше максимальной цены клика.'),
                    validate: function(val) {
                        return val > this.get('maxClickBid');
                    },
                    needToValidate: function(val) {
                        return !!val && this.get('maxClickBidEnabled');
                    }
                },
                lowerThenCPC: {
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt-102', 'Недельный бюджет должен быть больше средней цены клика.'),
                    validate: function(val) {
                        return val > (this._isFilter() ? this.get('cpcPerFilter') : this.get('cpcPerCamp'));
                    },
                    needToValidate: function(val) {
                        return !!val && (this._isFilter() ? !!this.get('cpcPerFilter') : !!this.get('cpcPerCamp'));
                    }
                }
            }
        }
    },

    /**
     * Максимальная цена клика
     */
    maxClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_PRICE');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna-103',
                            'Максимальная цена клика должна быть меньше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MAX_PRICE')
                            }
                        );
                    }
                },
                lowerThenCPC: {
                    text: iget2(
                        'b-strategy2-settings',
                        'znachenie-sredney-ceny-klika',
                        'Значение средней цены клика должно быть меньше или равно максимальной ставке.'
                    ),
                    validate: function(val) {
                        return val >= (this._isFilter() ? this.get('cpcPerFilter') : this.get('cpcPerCamp'));
                    },
                    needToValidate: function(val) {
                        return !!val && (this._isFilter() ? !!this.get('cpcPerFilter') : !!this.get('cpcPerCamp'));
                    }
                }
            }
        }
    },

    /**
     * CPC для кампании
     */
    cpcPerCamp: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: {
                    text: iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney', 'Не указано значение средней цены клика на кампанию'),
                    validate: function(val) { return !!val },
                    needToValidate: function() {
                        return (!this.get('isCpaPayForConversionEnabled')
                            || this.get('name') === 'autobudget_optimization_cpc')
                            && this._isCamp()

                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'minimalnoe-znachenie-sredney-ceny', 'Минимальное значение средней цены клика {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                        });
                    },
                    needToValidate: function(val) { return !!val && this._isCamp() }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'maksimalnoe-znachenie-sredney-ceny', 'Максимальное значение средней цены клика {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    },
                    needToValidate: function(val) { return !!val && this._isCamp() }
                }
            }
        }
    },

    /**
     * CPC для фильтра
     */
    cpcPerFilter: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: {
                    text: iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-104', 'Не указано значение средней цены клика на фильтр'),
                    validate: function(val) { return !!val },
                    needToValidate: function() {
                        return !this.get('disabledMetrika') && (this._isFilter() || !this._isCamp() && this.get('isNewCamp'));
                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'minimalnoe-znachenie-sredney-ceny', 'Минимальное значение средней цены клика {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                        });
                    },
                    needToValidate: function(val) {
                        return !!val && (this._isFilter() || !this._isCamp() && this.get('isNewCamp'));
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'maksimalnoe-znachenie-sredney-ceny', 'Максимальное значение средней цены клика {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    },
                    needToValidate: function(val) { return !!val && (this._isFilter() || !this._isCamp() && this.get('isNewCamp')); }
                }
            }
        }
    }
}, {
    /**
     * Возвращает результат проверки что сущностью стратегии является фильтр
     * @return {Boolean}
     */
    _isFilter: function() {
        return this.get('target') == 'filter';
    },

    /**
     * Возвращает результат проверки что сущностью стратегии является кампания
     * @return {Boolean}
     */
    _isCamp: function() {
        return this.get('target') == 'camp';
    }
});


