/**
 * Блок настроек стратегии Средняя цена клика
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.avg_bid – средняя цена клика
 */
block('b-strategy2-settings').mod('name', 'avg-click')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {};

        vmData.maxClickBid = dmData.bid || '';
        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.avgClickBid = dmData.avg_bid || '';
        vmData.weekBid = dmData.sum;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.currency = dmData.currency;
        vmData.clicksLimit = dmData.limit_clicks;
        vmData.clickBidEnabled = !!(dmData.avg_bid || dmData.bid);
        vmData.clickBidType = dmData.avg_bid ? 'avg' : 'max';
        vmData.clickBid = dmData.avg_bid || dmData.bid || '';

        this.mods.subtype = u['b-strategy2-settings_name_avg-click'].mapStrategyNameToMod(dmData.name);

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_avg-click'),

    elem('control').content()(function() {
        var modelData = this.modelData,
            currentName = modelData.name,
            itemDict = {},
            options;

            itemDict[u.strategy.AUTOBUDGET_AVG_CLICK] = iget2('b-strategy2-settings', 'by-avg-price', 'средней цене клика');
            itemDict[u.strategy.AUTOBUDGET] = iget2('b-strategy2-settings', 'by-week-budget', 'недельному бюджету');
            itemDict[u.strategy.AUTOBUDGET_WEEK_BUNDLE] = iget2('b-strategy2-settings', 'by-clicks-limit', 'пакету кликов');

            options = [u.strategy.AUTOBUDGET_AVG_CLICK, u.strategy.AUTOBUDGET, u.strategy.AUTOBUDGET_WEEK_BUNDLE].map(function(name) {
                return {
                    elem: 'radio',
                    controlAttrs: { value: name },
                    content: itemDict[name]
                };
            });

        return [
            {
                elem: 'row',
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-strategy2-settings', 'optimization-parameter-label', 'Ограничивать по') + '&nbsp;'
                    },
                    {
                        block: 'radio-button',
                        mix: [
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'name',
                                    type: 'radio-button'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'avg-click-parameter-control'
                            }
                        ],
                        value: currentName,
                        content: options
                    }
                ]
            },
            {
                elem: 'week-bid-control-2',
                currency: modelData.currency,
                weekBid: modelData.weekBid
            },
            {
                elem: 'week-bundle-control',
                clicksLimit: modelData.clicksLimit,
                currency: modelData.currency
            },
            {
                elem: 'row',
                mix: {
                    elem: 'avg-bid-price-control'
                },
                content: [
                    {
                        elem: 'label',
                        content: iget2('b-strategy2-settings', 'uderzhivat-cenu-klika', 'Удерживать цену клика') + '&nbsp;'
                    },
                    {
                        block: 'input',
                        mods: { clear: 'no' },
                        mix: [
                            {
                                block: 'b-hintable',
                                js: true
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'avgClickBid',
                                    type: 'formatted-input'
                                }
                            },
                            {
                                block: 'b-strategy2-settings',
                                elem: 'prevalidate-input',
                                js: {
                                    highValue: u.currencies.getConst(modelData.currency, 'AUTOBUDGET_AVG_PRICE_WARNING'),
                                    modelField: 'avgClickBid'
                                }
                            }
                        ],
                        value: modelData.avgClickBid ?
                            u.numberFormatter.roundFormatted(modelData.avgClickBid, {
                                precision: 2,
                                fail: ''
                            }) : '',
                        content: { elem: 'control' }
                    },
                    '&nbsp;',
                    {
                        elem: 'label',
                        content: iget2('b-strategy2-settings', 's-v-srednem-za', '{foo} в среднем за неделю', {
                            foo: this.currency
                        })
                    }
                ]
            },
            {
                elem: 'week-bid-control',
                weekBidEnabled: modelData.weekBidEnabled,
                weekBid: modelData.weekBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            {
                elem: 'max-click-bid-control',
                maxClickBidEnabled: modelData.maxClickBidEnabled,
                maxClickBid: modelData.maxClickBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            {
                elem: 'week-bundle-click-bid',
                clickBidEnabled: modelData.clickBidEnabled,
                clickBidType: modelData.clickBidType,
                clickBid: modelData.clickBid,
                currency: modelData.currency,
            }
        ];
    })
);
