/**
 * Модель стратегии "Средняя цена клика"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_avg-click', baseModel: 'b-strategy2-settings' }, {

    // цена клика
    avgClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('name') === u.strategy.AUTOBUDGET_AVG_CLICK;
            },
            rules: {
                required: {
                    text: iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-105', 'Не указано значение средней цены клика')
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_PRICE')
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'srednyaya-cena-za-klik', 'Средняя цена за клик должна быть не менее {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_PRICE')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'srednyaya-cena-za-klik-106', 'Средняя цена за клик не может превышать {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    }
                }
            }
        },
    },

    // уточнение недельного бюджета
    weekBidEnabled: 'boolean',

    // недельный бюджет
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                var name = this.get('name');

                if (name === u.strategy.AUTOBUDGET_AVG_CLICK) {
                    return this.get('weekBidEnabled');
                }

                return name === u.strategy.AUTOBUDGET;
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                min: {
                    needToValidate: function() {
                        return this.get('name') === u.strategy.AUTOBUDGET_AVG_CLICK;
                    },
                    value: function() {
                        return this.get('avgClickBid') || 0;
                    },
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt-102', 'Недельный бюджет должен быть больше средней цены клика.'),
                    required: true
                },
                anotherLte: {
                    validate: function(curValue, ruleValue) {
                        return curValue > ruleValue;
                    },
                    needToValidate: function() {
                        return this.get('name') === u.strategy.AUTOBUDGET &&
                            !!this.get('maxClickBid') &&
                            !!this.get('weekBid');
                    },
                    value: function() {
                        return this.get('maxClickBid')
                    },
                    text: {
                        required: true,
                        value: iget2(
                            'b-strategy2-settings',
                            'nedelnyy-byudzhet-dolzhen-byt-114',
                            'Недельный бюджет должен быть больше максимальной цены клика'
                        )
                    }
                }
            }
        }
    },

    // количество кликов в неделю
    clicksLimit: {
        type: 'optional-blank-number',
        precision: 0,
        validation: {
            needToValidate: function() {
                return this.get('name') === u.strategy.AUTOBUDGET_WEEK_BUNDLE;
            },
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazano-kolichestvo-klikov', 'Не указано количество кликов на неделю') },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_CLICKS_BUNDLE');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'kolichestvo-klikov-na-nedelyu', 'Количество кликов на неделю должно быть не менее {foo}', {
                            foo: u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_CLICKS_BUNDLE')
                        });
                    }
                },
                maxClicks: {
                    validate: function() {
                        return this.get('clicksLimit') <= u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_CLICKS_BUNDLE');
                    },
                    text: iget2('b-strategy2-settings', 'ukazano-slishkom-bolshoe-kolichestvo', 'Указано слишком большое количество кликов')
                }
            }
        }
    },

    // уточнение максимальной цены клика
    maxClickBidEnabled: 'boolean',

    // максимальная цена клика
    maxClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('name') === u.strategy.AUTOBUDGET && this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna-103',
                            'Максимальная цена клика должна быть меньше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                            }
                        );
                    }
                }
            }
        }
    },

    // уточнение цены клика
    clickBidEnabled: 'boolean',

    // цена клика
    clickBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('name') === u.strategy.AUTOBUDGET_WEEK_BUNDLE && this.get('clickBidEnabled');
            },
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazana-cena-klika', 'Не указана цена клика') },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: iget2('b-strategy2-settings', 'ukazana-stavka-menshe-minimalnoy', 'Указана ставка меньше минимальной цены клика')
                },
                maxBid: {
                    validate: function() {
                        return this.get('clickBid') <= u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ukazana-stavka-bolshe-s', 'Указана ставка больше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    }
                }
            }
        }
    },

    // тип уточнения цены клика
    clickBidType: {
        type: 'enum',
        enum: ['max', 'avg']
    },

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('average-cpc') || '';
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            var clickBidEnabled = this.get('clickBidEnabled'),
                clickBidType = this.get('clickBidType'),
                clickBid = this.get('clickBid'),
                options = {};

            switch (this.get('name')) {
                case u.strategy.AUTOBUDGET:
                        options.sum = this.get('weekBid');
                        options.bid = this.get('maxClickBidEnabled') ? this.get('maxClickBid') : '';
                        options.goal_id = '';
                    break;

                case u.strategy.AUTOBUDGET_WEEK_BUNDLE:
                    options.limit_clicks = this.get('clicksLimit');
                    options.bid = clickBidEnabled && clickBidType === 'max' ? clickBid : '';
                    options.avg_bid = clickBidEnabled && clickBidType === 'avg' ? clickBid : '';
                    break;

                case u.strategy.AUTOBUDGET_AVG_CLICK:
                default:
                    options.avg_bid = this.get('avgClickBid');
                    options.sum = this.get('weekBidEnabled') ? this.get('weekBid') : '';
                    break;
            }

            return options;
        }
    }
});
