/**
 * Блок настроек стратегии «Максимум просмотров видео» для cpm_banner кампаний
 * {Object} ctx.modelData – данные модели
 * {Number} ctx.modelData.sum – ставка недельного бюджета
 * {Number} ctx.modelData.avg_bid – средняя цена за 1 просмотр
 */
block('b-strategy2-settings').mod('name', 'avg-cpv')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {},
            calendar,
            currency = dmData.currency,
            campaignPeriod = this.ctx.campaignPeriod,
            defaultPrice = u.currencies.getConst(currency, 'DEFAULT_AVG_CPV'),
            // флаг, указывающий на то что стратегия действует
            // в случае редактирования стратегия запускается заново
            isSavedPeriodStrategy = this.ctx.strategyName === 'autobudget_avg_cpv_custom_period' && !!dmData.budget,
            isSavedWeekStrategy = this.ctx.strategyName === 'autobudget_avg_cpv' && !!dmData.sum;

        vmData.autoProlongation = true;
        vmData.isAvgCpv = true;
        vmData.isSavedPeriodStrategy = isSavedPeriodStrategy;
        vmData.coveragePeriodMode = 'wide';
        vmData.coverageWeekMode = 'wide';
        vmData.spendMode = 'period';
        vmData.clickBidPeriod = defaultPrice;
        vmData.clickBid = defaultPrice;
        vmData.currency = currency;
        vmData.campaignPeriod = {
            start: campaignPeriod.start,
            finish: campaignPeriod.finish
        };

        if (isSavedPeriodStrategy) {
            vmData.budget = dmData.budget || '';
            vmData.clickBidPeriod = dmData.avg_cpv;
            vmData.autoProlongation = dmData.auto_prolongation == 1;
            vmData.period = {
                start: dmData.start,
                finish: dmData.finish
            };
            vmData.spendMode = 'period';
            vmData.lastStrategyChange = dmData.lastStrategyChange;
        }

        if (isSavedWeekStrategy) {
            var coverageModeLocal = dmData.coverageWeekMode,
                coverageModeFromServer = dmData.strategyCmpAutoCoverage;

            vmData.weekBid = dmData.sum || '';
            vmData.clickBid = dmData.avg_cpv;
            vmData.coverageWeekMode = coverageModeLocal || coverageModeFromServer;
            vmData.spendMode = 'week';
        }

        // получаем стандартные настройки календаря для стратегии «за период»
        calendar = u['b-strategy2-settings'].getCalendarSettings({
            strategyStart: dmData.start,
            strategyFinish: dmData.finish,
            campaignStart: campaignPeriod.start,
            campaignFinish: campaignPeriod.finish
        });

        // применяем стандартные настройки календаря
        vmData.defaultCalendarSettings = calendar;
        vmData.period_range = calendar.range;

        if (!vmData.period) {
            vmData.period = {
                start: calendar.start,
                finish: calendar.finish
            };
        }

        return applyNext({
            modelData: vmData,
            isSavedPeriodStrategy: isSavedPeriodStrategy,
            isSavedWeekStrategy: isSavedWeekStrategy
        });
    }),

    mode('model')('b-strategy2-settings_name_avg-cpv'),

    elem('control').content()(function() {
        var vmData = this.modelData;

        return {
            elem: 'coverage-control',
            elemMods: {
                'spend-mode': vmData.spendMode,
                'period-in': this.isSavedPeriodStrategy ? 'progress' : '',
                'week-in': this.isSavedWeekStrategy ? 'progress' : ''
            },
            mediaType: vmData.mediaType,
            isSavedPeriodStrategy: this.isSavedPeriodStrategy,
            spendMode: vmData.spendMode,
            coveragePeriodMode: vmData.coveragePeriodMode,
            coverageWeekMode: vmData.coverageWeekMode,
            calendar: vmData.defaultCalendarSettings,
            weekBid: vmData.weekBid,
            clickBid: vmData.clickBid,
            currency: vmData.currency,
            period: vmData.period,
            cid: vmData.cid,
            period_range: vmData.period_range,
            budget: vmData.budget,
            clickBidPeriod: vmData.clickBidPeriod,
            autoProlongation: vmData.autoProlongation,
            minAutobudgetAvgCpv: vmData.minAutobudgetAvgCpv,
            isSavedPeriodStrategyEditable: this.isSavedPeriodStrategyEditable,
            isAvgCpv: vmData.isAvgCpv
        };
    })
);
