/**
 * Модель стратегии «Максимум просмотров видео»
 */
BEM.MODEL.decl({
    model: 'b-strategy2-settings_name_avg-cpv',
    baseModel: 'b-strategy2-settings_type_cpm-auto'
}, {

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('maximum-video-views');
        }
    },

    name: {
        type: 'string',
        dependsFrom: ['spendMode'],
        calculate: function(mode) {
            return {
                period: 'autobudget_avg_cpv_custom_period',
                week: 'autobudget_avg_cpv'
            }[mode];
        }
    }

});
