/**
 * Блок настроек стратегии Средняя цена конверсии
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.avg_cpa – конверсия
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 */
block('b-strategy2-settings').mod('name', 'cpa')(
    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {},
            rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(dmData.mediaType),
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            defaultGoalId = undefined;

        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';
        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.cpa = dmData.avg_cpa;
        vmData.goalId = dmData.goal_id || (rmpGoalsEnabled ? u.strategy.MOBILE_CPA_GOAL_ID : defaultGoalId);
        vmData.initGoalId = vmData.goalId;
        vmData.isNewCamp = dmData.isNewCamp;
        vmData.currency = dmData.currency;
        vmData.minGoalsOnCampaign = dmData.minGoalsOnCampaign;
        vmData.metrikaRequestRunning = (this.ctx.metrikaCounter || rmpGoalsEnabled) ? !failedToFetchMetrika : false;
        vmData.isCpaPayForConversionsStrategyAllowed = dmData.isCpaPayForConversionsStrategyAllowed;
        vmData.isCpaPayForConversionEnabled = dmData.isCpaPayForConversionEnabled;

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_cpa'),

    elem('control')(

        mix()(function() {
            if (u.strategy.isRmpGoalsAvailable(this.modelData.mediaType)) {
                return {};
            }

            return {
                block: 'b-strategy2-settings',
                elem: 'model-field',
                js: {
                    name: 'disabledMetrika',
                    type: 'mod',
                    block: 'b-strategy2-settings',
                    elem: 'control',
                    modName: 'disabled'
                }
            }
        }),

        content()(function() {
            var modelData = this.modelData,
                currency = this.currency;

            if (modelData.metrikaRequestRunning) {
                return {
                    block: 'spin',
                    js: true,
                    mods: {
                        progress: 'yes',
                        theme: 'gray-16'
                    }
                };
            }

            return {
                elem: 'control-cpa',
                modelData: modelData,
                currency: currency
            };
        })
    )
);
