/**
 * Стратегия "Средняя цена конверсии"
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'cpa' }, {
    onSetMod: {
        js: function () {
            this.__base.apply(this, arguments);

            var metrika = this.model.get('metrika'),
                goals = metrika.campaign_goals,
                cid = this.model.get('cid'),
                isCpaPayForConversionsStrategyAllowed = this.model.get('isCpaPayForConversionsStrategyAllowed'),
                currentGoals,
                rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(this.model.get('mediaType')),
                requests,
                goalId,
                disabled,
                failedToFetchMetrika = u.consts('failedToFetchMetrika');

            // кэшируем плейсхолдер контрола
            this.elem('control');

            this.model.on('metrikaRequestRunning', 'change', function (data) {
                if (!data.value) {
                    this._initControl();

                    this._listenToPayForConversionFlag(true);
                    this._setInitVisibleMaxBidsCheckbox();
                }
            }, this);

            this.model.on('goalId', 'change', function (event, data) {
                var allKeyGoalsSelected = data.value === u.consts('allKeyGoals'),
                    checkbox = this.findBlockOn('checkbox-control', 'checkbox');

                if (allKeyGoalsSelected) {
                    // для "Ключевых целей" (goalId = 13) значение "cpa" должно быть убрано т.к. оно не допустипо для этой цели
                    this.model.set('cpa', undefined);
                }

                this.findBlockOn('cpa-input', 'input').setMod('disabled', allKeyGoalsSelected ? 'yes' : '');
                checkbox && checkbox.setMod('disabled', allKeyGoalsSelected ? 'yes' : '');
                this.toggleMod(this.elem('all-key-goals-notification'), 'hidden', '', 'yes', allKeyGoalsSelected);
            }, this);

            this._setInitVisibleMaxBidsCheckbox();

            this.model.on('isCpaPayForConversionEnabled', 'change', this._changeControlVisibility, this);

            if (failedToFetchMetrika) {

                this.delMod(this.elem('control'), 'disabled');
                this.setMod(this.elem('row'), 'visible', 'yes');

            } else if (this.model.get('metrikaRequestRunning')) {
                if (!this.model.get('metrikaCounter') && (!isCpaPayForConversionsStrategyAllowed && !rmpGoalsEnabled)) {

                    this.model.set('metrikaRequestRunning', false);
                    this.setMod(this.elem('control'), 'disabled', this.model.get('metrikaWarning').code === 'no-metrika-optional-visits' ? 'yes' : '');

                } else {

                    requests = this.model.get('metrikaCounter').split(', ').map(function(metrikaCounter) {
                        return this._requestMetrikaCounterForGoals(metrikaCounter, cid);
                    }.bind(this));

                    $.when.apply($, requests)
                        .then(function() {
                            currentGoals = goals.map(function(goal) {
                                return goal.goal_id.toString();
                            });

                            u._.each(arguments, function(availableGoals) {
                                availableGoals.forEach(function(goal) {
                                    goalId = goal.id.toString();
                                    if (currentGoals.indexOf(goalId) === -1) {
                                        goal = {
                                            goal_name: goal.name,
                                            goal_id: goalId,
                                            goal_type: goal.goal_type,
                                            parent_goal_id: goal.parent_goal_id,
                                            counter_status: 'Active',
                                            goal_status: 'Active'
                                        };
                                        goals.push(goal);
                                    }
                                });
                            });

                            this.model.set('metrika', metrika);
                            this.campaignModel.set('metrika', metrika);
                            this.model.set('metrikaRequestRunning', false);
                            disabled = !rmpGoalsEnabled && this.model.get('metrikaWarning').code === 'no-metrika-optional-visits';
                            this.setMod(this.elem('control'), 'disabled', disabled ? 'yes' : '');

                            if (this.model.get('goalId') === u.consts('allKeyGoals')) {
                                this.model.set('cpa', undefined);
                                this.findBlockOn('cpa-input', 'input').setMod('disabled', 'yes');
                                this.setMod(this.elem('all-key-goals-notification'), 'hidden', '');
                            }

                        }.bind(this))
                        .fail(function() {
                            this.model.set('metrikaRequestRunning', false);
                            if (rmpGoalsEnabled) {
                                this.setMod(this.elem('control'), 'disabled', '');
                            } else {
                                disabled = this.model.get('metrikaWarning').code === 'no-metrika-optional-visits';
                                this.setMod(this.elem('control'), 'disabled', disabled ? 'yes' : '');
                                this.setMod(this.elem('row'), 'visible', disabled ? 'no' : 'yes');
                            }
                        }.bind(this));
                }

            }

        },

        /**
         * Пересчитываем метрику при смене платформы
         * @param {String} modName = 'platform'
         * @param {String} modValue - тип платформы
         */
        platform: function (modName, modValue) {
            // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
            // настоящее изменение платформы зафиксируется в модели chooser-а
            this.model.set('where', modValue == u.strategy.NET ? 'context' : 'search').fix();
            this._updateMetrika('cpa',
                u.getMetrikaWarning(
                    this.model.get('metrika'),
                    this.model.get('goalId'),
                    this.model.get('where'),
                    undefined,
                    u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                    this.model.get('metrikaCounter')
                )
            );
        },

        /**
         * Пересчитываем метрику при смене платформы
         */
        show: function () {
            // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
            // настоящее изменение платформы зафиксируется в модели chooser-а
            this.model.set('where', this.getMod('platform') == u.strategy.NET ? 'context' : 'search').fix();
            this._updateMetrika('cpa',
                u.getMetrikaWarning(
                    this.model.get('metrika'),
                    this.model.get('goalId'),
                    this.model.get('where'),
                    undefined,
                    u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                    this.model.get('metrikaCounter')
                )
            );
        },
    },

    /**
     * Инициализирует содержимое блока
     * @private
     */
    _initControl: function(inactive) {
        var metrika = this.model.get('metrika');

        BEM.DOM.update(this.elem('control'), BEMHTML.apply({
            block: 'b-strategy2-settings',
            elem: 'control-cpa',
            modelData: this.model.toJSON(),
            currency: this.params.currency
        }));

        this._updateMetrikaWarning(this.model.get('metrikaWarning'))

        if (inactive) {
            return;
        }

        [
            this.findElem('cpa-input'),
            this.findElem('goal-select-control'),
            this.findElem('goal-select-special-control'),
            this.findElem('max-click-bid-toggle'),
            this.findElem('all-key-goals-unavailable-warning'),
            this.findElem('all-key-goals-notification'),
            this.findElem('week-bid-control-toggle'),
            this.findElem('not-optimal-goal-notification'),
            this.findElem('input-control', 'field', 'maxClickBid'),
            this.findElem('input-control', 'field', 'weekBid')
        ].forEach(function(elem) {
            elem && elem.length && this.initFieldBlock(elem);
        }.bind(this));

        this.initToggleRow();
    },

    isCpaPayForConversionEnabled: function() {
        return this.model.get('isCpaPayForConversionEnabled');
    }
});
