/**
 * Модель стратегии "Средняя цена конверсии"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_cpa', baseModel: 'b-strategy2-settings' }, {

    // уточнение максимальной цены клика
    maxClickBidEnabled: 'boolean',

    // уточнение недельного бюджета
    weekBidEnabled: 'boolean',

    // id рекламной кампании
    cid: 'number',

    // недельный бюджет
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('weekBid') !== undefined;
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                min: {
                    value: function() {
                        return (this.get('isCpaPayForConversionEnabled') && this.get('cpa')) ?
                            this.get('cpa') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')
                            : 0
                    },
                    needToValidate: function() {
                        return (this.get('cpa') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')) !== this.get('weekBid');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'check-that-week-budget-more-then-cpa', 'Недельный бюджет должен гарантировать покупку {foo} конверсий в неделю по целевому CPA', {
                            foo: u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')
                        })
                    }
                }
            }
        }
    },

    // максимальная цена клика
    maxClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna-103',
                            'Максимальная цена клика должна быть меньше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                            }
                        );
                    }
                },
                max: {
                    value: function() {
                        return this.get('weekBid');
                    },
                    needToValidate: function() {
                        return this.get('weekBid') !== undefined;
                    },
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt-107', 'Недельный бюджет должен быть больше максимальной ставки')
                }
            }
        }
    },

    // средняя цена конверсии
    cpa: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: {
                    needToValidate: function() {
                        return !this.get('disabledMetrika') && (this.get('isCpaPayForConversionEnabled') || this.get('weekBid') === undefined);
                    },
                    text: function() {
                        if (this.get('goalId') === u.consts('allKeyGoals')) {
                            return iget2('b-strategy2-settings', 'must-set-week-bid', 'Укажите недельный бюджет');
                        }

                        if (!this.get('isCpaPayForConversionEnabled')) {
                            return iget2('b-strategy2-settings', 'must-set-cpa-price-or-week-bid', 'Укажите среднюю цену конверсии или недельный бюджет');
                        }

                        return iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-108', 'Не указано значение средней цены конверсии');
                    }
                },
                lte: {
                    needToValidate: function() {
                        return this.get('cpa') !== undefined;
                    },
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_CPA');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'srednyaya-cena-konversii-dolzhna',
                            'Средняя цена конверсии должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_CPA')
                            }
                        );
                    }
                },
                gte: {
                    needToValidate: function() {
                        return this.get('cpa') !== undefined;
                    },
                    value: function() {
                        return (
                            this.get('isCpaPayForConversionEnabled')
                        ) ?
                            u.consts('increasedCpaLimitForPayForConversion')
                                ? u.currencies.getConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED')
                                : u.currencies.getConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING') :
                            u.currencies.getConst(this.get('currency'), 'AUTOBUDGET_AVG_CPA_WARNING');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'srednyaya-cena-konversii-ne', 'Средняя цена конверсии не может быть больше {foo}', {
                            foo: (
                                this.get('isCpaPayForConversionEnabled')
                            ) ?
                                u.consts('increasedCpaLimitForPayForConversion')
                                    ? u.currencies.formatConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED')
                                    : u.currencies.formatConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING') :
                                u.currencies.formatConst(this.get('currency'), 'AUTOBUDGET_AVG_CPA_WARNING')
                        });
                    }
                },
                max: {
                    value: function() {
                        return this.get('weekBid');
                    },
                    needToValidate: function() {
                        return (this.get('weekBid') !== undefined && this.get('cpa') !== undefined)
                    },
                    text: iget2(
                        'b-strategy2-settings',
                        'nedelnyy-byudzhet-dolzhen-byt-109',
                        'Недельный бюджет должен быть больше средней цены конверсии.'
                    )
                }
            }
        }
    },

    // идентификатор цели в Метрике
    goalId: {
        type: 'string',
        validation: {
            needToValidate: function() {
                return !this.get('disabledMetrika');
            },
            rules: {
                required: {
                    text: iget2('b-strategy2-settings', 'neobhodimo-vybrat-cel', 'Необходимо выбрать цель')
                },
                goalSelected: {
                    needToValidate: function() {
                        return this.get('isNewCamp') || this.get('initGoalId') !== '0'
                    },
                    validate: function() {
                        return this.get('goalId') !== '0';
                    },
                    text: iget2('b-strategy2-settings', 'neobhodimo-vybrat-cel', 'Необходимо выбрать цель')
                }
            }
        }
    },

    // начальное значение идентификатора цели (значение не изменяется)
    initGoalId: 'string',

    // Является ли кампания новой
    isNewCamp: 'boolean',

    // предупреждение о неоптимальной выбранной оптимизации "по всем целям"
    showNotOptimalGoalNotification: {
        dependsFrom: ['goalId'],
        calculate: function() {
            return this.get('goalId') === '0';
        }
    },

    hasNonDefaultGoals: {
        calculate: function() {
            return this.get('meaningfulGoals').some(function (goal) {
                return goal.goal_id !== u.consts('keyGoalsEngagedSessions');
            })
        }
    },

    showAllKeyGoalsUnavailableWarning: {
        dependsFrom: ['goalId'],
        calculate: function() {
            return this.get('goalId') === u.consts('allKeyGoals') && !this.get('hasNonDefaultGoals');
        }
    },

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('average-cpa') || '';
        }
    },

    // предупреждение Метрики
    metrikaWarning: {
        type: 'object',
        dependsFrom: ['goalId', 'where', 'metrikaRequestRunning', 'metrika', 'metrikaCounter'],
        calculate: function() {
            var data = u['b-strategy2-settings'].getMetrikaWarningsText(this.get('name'), this.get('metrika'), this.get('goalId'), this.get('where'), this.get('metrikaCounter'));

            if (this.get('isCpaPayForConversionEnabled') && data.code === 'no-metrika-optional-visits') {
                return {};
            }

            return data;
        },
        validation: {
            validate: function() {
                return u.strategy.isRmpGoalsAvailable(this.get('mediaType')) || this.get('isCpaPayForConversionEnabled') || !this.get('disabledMetrika');
            },
            text: {
                value: iget2('b-strategy2-settings', 'pered-nastrojkoj-strategii-ukazhite-schetchik-metriki', 'Перед настройкой стратегии укажите счетчик Метрики и задайте ключевые цели кампании'),
                only: true
            }
        }
    },

    name: {
        type: 'string',
        calculate: function() {
            return !!this.get('cpa') ? u.strategy.AUTOBUDGET_AVG_CPA : u.strategy.AUTOBUDGET;
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            var isCpaPayForConversionEnabled = this.get('isCpaPayForConversionEnabled');

            var options = {
                bid: (!isCpaPayForConversionEnabled && this.get('maxClickBidEnabled')) ? this.get('maxClickBid') : '',
                sum: this.get('weekBid') || '',
                goal_id: String(this.get('goalId')),
            };

            if (this.get('name') === u.strategy.AUTOBUDGET_AVG_CPA) {
                options.avg_cpa = this.get('cpa');
                options.pay_for_conversion = isCpaPayForConversionEnabled ? 1 : 0
            }

            return options;
        }
    },

    // признак того, что выполняется ajax запрос за метрикой
    metrikaRequestRunning: 'boolean'
});
