/**
 * Блок настроек стратегии Средняя цена установки приложения
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.avg_cpa – конверсия
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 * {String} ctx.modelData.goal_id – id цели Метрики
 */
block('b-strategy2-settings').mod('name', 'cpi')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {};

        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';
        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.cpi = dmData.avg_cpi;
        vmData.goalId = (dmData.goal_id == u.consts('allKeyGoals') ? null : dmData.goal_id) || u.strategy.MOBILE_CPA_GOAL_ID;
        vmData.currency = dmData.currency;

        vmData.isTrackUrlNeeded = dmData.isTrackUrlNeeded;
        vmData.mobileAppHasTrackUrl = dmData.mobileAppHasTrackUrl;

        vmData.isCpaPayForConversionsStrategyAllowed = dmData.isCpaPayForConversionsStrategyAllowed;
        vmData.isCpaPayForConversionEnabled = dmData.isCpaPayForConversionEnabled;

        // если стратегия была сохранена ранее на сервере, но сейчас не разрешено использовать стратегию
        // по показателям РМП счетчика,
        // то блоки не скрываем - просто дисаблим контролы
        vmData.isReadOnly = !dmData.rmpCounters.allow_autobudget_avg_cpi && dmData.isSaved;
        vmData.isDisabled = !dmData.rmpCounters.allow_autobudget_avg_cpi && !dmData.isSaved;

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_cpi'),

    elem('control')(

        match(function() {
            return this.modelData.isDisabled;
        })(function() {
            return applyNext({
                'mods.disabled': 'yes'
            });
        }),

        content()(function() {
            var modelData = this.modelData,
                goalId = modelData.goalId,
                currency = this.currency,
                isCpaPayForConversionsStrategyAllowed = modelData.isCpaPayForConversionsStrategyAllowed,
                isCpaPayForConversionEnabled = modelData.isCpaPayForConversionEnabled,
                goalsIdName = u['goalsIdName'],
                techGoalsIdName = u['techGoalsIdName'],
                options = [],
                tmpGoals = {},
                isUserInAppEventsInRmpEnabled = u.consts('isUserInAppEventsInRmpEnabled'),
                elements;

            function getGoalsOptions(idAndNames) {
                return Object.keys(idAndNames).map(function(id) {
                    return {
                        elem: 'option',
                        attrs: { value: id, selected: goalId === id.toString() ? 'selected' : undefined },
                        content: idAndNames[id]
                    };
                });
            }

            if (u.consts('isTechInAppEventsInRmpEnabled')) {
                options = options
                    .concat(getGoalsOptions(techGoalsIdName))
                    .concat(getGoalsOptions(goalsIdName));
            } else {
                if (isUserInAppEventsInRmpEnabled) {
                    // если выбранная цель не входит в список доступных, то добавляем её
                    if (techGoalsIdName[goalId]) {
                        tmpGoals[goalId] = techGoalsIdName[goalId];
                        options = options.concat(getGoalsOptions(tmpGoals));
                    }

                    options = options.concat(getGoalsOptions(goalsIdName));
                }
            }

            elements = {
                avgCpiControl: {
                    elem: 'row',
                    content: iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-avg', '{spend} {avg} {input} {week}', {
                        spend: {
                            elem: 'label',
                            mods: { readonly: modelData.isReadOnly ? 'yes' : '' },
                            content: iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-param',
                                'Удерживать цену конверсии') + '&nbsp;'
                        },
                        avg: {
                            elem: 'label',
                            mods: { readonly: modelData.isReadOnly ? 'yes' : '' },
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'cpa-avg-input-text'
                            },
                            content: iget2('b-strategy2-settings',
                                'uderzhivanie-v-srednem', 'в среднем') + '&nbsp;'
                        },
                        input: {
                            block: 'input',
                            mods: {
                                clear: 'no',
                                disabled: modelData.isReadOnly ? 'yes' : ''
                            },
                            mix: [
                                {
                                    block: 'b-hintable',
                                    js: true
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'cpi',
                                        type: 'formatted-input'
                                    }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'prevalidate-input',
                                    js: {
                                        highValue: u.currencies.getConst(modelData.currency, 'AUTOBUDGET_AVG_CPA_WARNING'),
                                        modelField: 'cpi'
                                    }
                                }
                            ],
                            value: modelData.cpi ?
                                u.numberFormatter.roundFormatted(modelData.cpi, {
                                    precision: 2,
                                    fail: ''
                                })
                                : '',
                            content: { elem: 'control' }
                        },
                        week: {
                            elem: 'label',
                            mods: { readonly: modelData.isReadOnly ? 'yes' : '' },
                            content: [
                                {
                                    tag: 'span',
                                    content: '&nbsp;' + currency
                                },
                                {
                                    tag: 'span',
                                    elem: 'period-week',
                                    content: '&nbsp;' + iget2('b-strategy2-settings', 'spend-uderzhivat-cenu-konversii-param-week', 'в неделю')
                                }
                            ]
                        }
                    })
                },
                cpaPayForConversionsCheckbox: {
                    elem: 'row',
                    content: [
                        {
                            block: 'checkbox',
                            mods: { checked: isCpaPayForConversionEnabled ? 'yes' : '' },
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'isCpaPayForConversionEnabled',
                                        type: 'checkbox'
                                    }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'checkbox-control'
                                }
                            ],
                            text: iget2('b-strategy2-settings', 'pay-for-conversions', 'Оплата за конверсии')
                        },
                        {
                            block: 'b-help-link',
                            mix: [
                                {
                                    block: 'b-hintable-popup',
                                    js: {
                                        hint: iget2('b-strategy2-settings', 'hint-pay-for-conversion', "При включении опции «Оплата за конверсии» вы платите за каждое достижение указанного вами целевого визита."),
                                        directions: ['bottom','right'],
                                        mixPopup: { block: 'b-strategy2-settings', elem: 'popup-conversion-hint' }
                                    }
                                }
                            ]
                        }
                    ]
                },
                goalIdControl: {
                    elem: 'row',
                    content: [
                        {
                            elem: 'label',
                            content: iget2('b-strategy2-settings', 'goal', 'Цель ')
                        },
                        {
                            block: 'select',
                            mods: (!modelData.cpi && !isUserInAppEventsInRmpEnabled) ? {
                                disabled: 'yes'
                            } : {},
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: (!isUserInAppEventsInRmpEnabled) ? [
                                        {
                                            name: 'goalId',
                                            type: 'select'
                                        },
                                        {
                                            type: 'mod',
                                            name: 'disabledGoalSelect',
                                            block: 'select',
                                            modName: 'disabled'
                                        }
                                    ] : {
                                        name: 'goalId',
                                        type: 'select'
                                    }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'goal-select'
                                }
                            ],
                            content: [
                                { block: 'button' },
                                {
                                    elem: 'control',
                                    content: options
                                }
                            ]
                        }
                    ]
                },
                weekBidControl: {
                    elem: 'week-bid-control',
                    elemMods: {
                        collapsible: 'no'
                    },
                    weekBidEnabled: modelData.weekBidEnabled,
                    weekBid: modelData.weekBid,
                    currency: modelData.currency,
                    isReadOnly: modelData.isReadOnly
                },
                maxClickBidControl: {
                    elem: 'max-click-bid-control',
                    maxClickBidEnabled: modelData.maxClickBidEnabled,
                    maxClickBid: modelData.maxClickBid,
                    currency: modelData.currency,
                    isReadOnly: modelData.isReadOnly
                },
                rmpCountersWarning: {
                    elem: 'rmp-counters-warning'
                }
            };

            return [
                isCpaPayForConversionsStrategyAllowed && elements.cpaPayForConversionsCheckbox,
                !!options.length && elements.goalIdControl,
                elements.avgCpiControl,
                elements.weekBidControl,
                elements.maxClickBidControl,
                elements.rmpCountersWarning
            ];
        })
    )
);
