BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'cpi' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._setInitVisibleMaxBidsCheckbox();

            this.model.on('isCpaPayForConversionEnabled', 'change', this._setInitVisibleMaxBidsCheckbox, this);
        }
    },

    _setInitVisibleMaxBidsCheckbox: function() {
        var maxClickBid = this.findElem('max-click-bid-control'),
            cpaPeriod = this.findElem('period-week'),
            cpaAvg = this.findElem('cpa-avg-input-text'),
            isCpaPayForConversionsStrategyAllowed = this.model.get('isCpaPayForConversionsStrategyAllowed');

        if (isCpaPayForConversionsStrategyAllowed && this.model.get('isCpaPayForConversionEnabled')) {
            this.setMod(maxClickBid, 'visible', 'no');
            this.setMod(cpaPeriod, 'visible', 'no');
            this.setMod(cpaAvg, 'visible', 'no');
            this.setMod(this.findElem('max-click-bid-control'), 'visible', 'no');
        } else {
            this.setMod(maxClickBid, 'visible', 'yes');
            this.setMod(cpaPeriod, 'visible', 'yes');
            this.setMod(cpaAvg, 'visible', 'yes');
            this.setMod(this.findElem('max-click-bid-control'), 'visible', 'yes');
        }
    },

    isCpaPayForConversionEnabled: function() {
        return this.model.get('isCpaPayForConversionEnabled');
    }
});
