/**
 * Модель стратегии "Средняя цена установки приложения"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_cpi', baseModel: 'b-strategy2-settings' }, {

    // уточнение максимальной цены клика
    maxClickBidEnabled: 'boolean',

    // уточнение недельного бюджета
    weekBidEnabled: 'boolean',

    // недельный бюджет
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('weekBid') !== undefined;
            },
            rules: {
                required: {
                    needToValidate: function() {
                        var isInAppEventsInRmpEnabled = u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled');

                        if (isInAppEventsInRmpEnabled) {
                            // в случае если выбрана цель "установка приложения", должна быть указана средняя цена конверсии или недельный бюджет
                            return this.get('goalId') === '4';
                        }
                        return false;
                    },
                    text: function () {
                        return iget2('b-strategy2-settings', 'must-set-cpa-price-or-week-bid', 'Укажите среднюю цену конверсии или недельный бюджет');
                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                min: {
                    needToValidate: function() {
                        return this.get('isCpaPayForConversionEnabled') ?
                            this.get('cpi') !== undefined &&
                                (this.get('cpi') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')) !== this.get('weekBid'):
                            this.get('cpi') !== undefined;
                    },
                    value: function() {
                        return this.get('isCpaPayForConversionEnabled') ?
                            this.get('cpi') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO') :
                            this.get('cpi');
                    },
                    text: function() {
                        return this.get('isCpaPayForConversionEnabled') ?
                            iget2(
                                'b-strategy2-settings',
                                'avg-cpc-ratio-weekly-budget-limit-error',
                                'Увеличьте недельный бюджет. Размера недельного бюджета должно хватать для привлечения не менее {limit} конверсий.',
                                { limit: u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO') }
                            ) :
                            (u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled') ?
                                iget2(
                                    'b-strategy2-settings',
                                    'nedelnyy-byudzhet-dolzhen-byt-109',
                                    'Недельный бюджет должен быть больше средней цены конверсии.'
                                ) :
                                iget2(
                                    'b-strategy2-settings',
                                    'nedelnyy-byudzhet-dolzhen-byt-110',
                                    'Недельный бюджет должен быть больше средней цены установки приложения'
                                ));
                    },
                    required: true
                }
            }
        }
    },

    // максимальная цена клика
    maxClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna-103',
                            'Максимальная цена клика должна быть меньше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                            }
                        );
                    }
                }
            }
        }
    },

    // средняя цена конверсии
    cpi: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: {
                    needToValidate: function() {
                        // в случае если выбрана цель, отличная от "установки приложения", средняя цена конверсии обязательна
                        return this.get('goalId') === '4' ?
                            this.get('weekBid') === undefined || this.get('isCpaPayForConversionEnabled') :
                            true;
                    },
                    text: function () {
                        return iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-108', 'Не указано значение средней цены конверсии');
                    }
                },
                lte: {
                    needToValidate: function() {
                        return this.get('cpi') !== undefined;
                    },
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_CPA');
                    },
                    text: function() {
                        var isInAppEventsInRmpEnabled = u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled');

                        return isInAppEventsInRmpEnabled ?
                            iget2(
                                'b-strategy2-settings',
                                'srednyaya-cena-konversii-dolzhna',
                                'Средняя цена конверсии должна быть больше или равна {foo}',
                                {
                                    foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_CPA')
                                }
                            ) :
                            iget2(
                                'b-strategy2-settings',
                                'srednyaya-cena-ustanovki-prilozheniya',
                                'Средняя цена установки приложения должна быть больше или равна {foo}',
                                {
                                    foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_AVG_CPA')
                                }
                            );
                    }
                },
                gte: {
                    needToValidate: function() {
                        return this.get('cpi') !== undefined;
                    },
                    value: function() {
                        return this.get('isCpaPayForConversionEnabled') ?
                            u.consts('increasedCpaLimitForPayForConversion')
                                ? u.currencies.getConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED')
                                : u.currencies.getConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING') :
                            u.currencies.getConst(this.get('currency'), 'MAX_PRICE');
                    },
                    text: function() {
                        var isInAppEventsInRmpEnabled = u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled');

                        return this.get('isCpaPayForConversionEnabled') ?
                            iget2(
                                'b-strategy2-settings',
                                'conversion-price-cannot-be-mo-than',
                                'Цена конверсии не может быть больше {foo}',
                                {
                                    foo: u.consts('increasedCpaLimitForPayForConversion')
                                        ? u.currencies.formatConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED')
                                        : u.currencies.formatConst(this.get('currency'), 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING')
                                }
                            ) :
                            isInAppEventsInRmpEnabled ?
                                iget2(
                                    'b-strategy2-settings',
                                    'srednyaya-cena-konversii-ne',
                                    'Средняя цена конверсии не может быть больше {foo}',
                                    {
                                        foo: u.currencies.formatConst(this.get('currency'), 'MAX_PRICE')
                                    }
                                ) :
                                iget2(
                                    'b-strategy2-settings',
                                    'tselevaya-stoimost-ustanovki-prilozheniya',
                                    'Средняя цена установки не должна превышать {foo}',
                                    {
                                        foo: u.currencies.formatConst(this.get('currency'), 'MAX_PRICE')
                                    }
                                );
                    }
                }
            }
        }
    },

    // эта стратегия была сохранена на сервере
    isSaved: 'boolean',

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('average-cpi') || '';
        }
    },

    // предупреждение Счетчика РМП
    rmpCountersWarning: {
        type: 'string',

        calculate: function() {
            var isInAppEventsInRmpEnabled = u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled'),
                errorCode,
                rmpCountersData = this.get('rmpCounters'),
                warnings = {
                    'rmp-counters-no-cpi-data': iget2('b-strategy2-settings', 'dlya-pereklyucheniya-na-dannuyu', 'Для переключения на данную стратегию недостаточно данных.'),
                    'rmp-counters-decrease-setup': isInAppEventsInRmpEnabled ?
                        iget2(
                            'b-strategy2-settings',
                            'alert-too-few-conversions',
                            'Внимание! Мало конверсий.'
                        ) :
                        iget2(
                            'b-strategy2-settings',
                            'vnimanie-malo-ustanovok',
                            'Внимание! Мало установок.'
                        ),
                    'rmp-counters-apps-count': isInAppEventsInRmpEnabled ?
                        iget2(
                            'b-strategy2-settings',
                            'alert-optimize-conversions-not-recommended',
                            'Внимание! Не рекомендуется использовать оптимизацию конверсий в кампаниях, рекламирующих более одного приложения.'
                        ) :
                        iget2(
                            'b-strategy2-settings',
                            'vnimanie-ne-rekomenduetsya-ispolzovat-112',
                            'Внимание! Не рекомендуется использовать среднюю цену установки в кампаниях, рекламирующих более одного приложения.'
                        ),
                    'rmp-counters-cpi-deviation': isInAppEventsInRmpEnabled ?
                        iget2(
                            'b-strategy2-settings',
                            'alert-cpa-price-varies-dramatically',
                            'Внимание! Стоимость конверсии значительно отличается от выбранного значения.'
                        ) :
                        iget2(
                            'b-strategy2-settings',
                            'vnimanie-stoimost-ustanovki-znachitelno',
                            'Внимание! Стоимость установки значительно отличается от выбранного значения.'
                        ),
                    'rmp-counters-setup-deviation': isInAppEventsInRmpEnabled ?
                        iget2(
                            'b-strategy2-settings',
                            'alert-conversion-rate-changed',
                            'Внимание! Количество конверсий резко изменилось. Стоимость конверсии может значительно отличаться от заданного значения.'
                        ) :
                        iget2(
                            'b-strategy2-settings',
                            'vnimanie-kolichestvo-ustanovok-prilozheniya',
                            'Внимание! Количество установок приложения резко изменилось. Стоимость установок может значительно отличаться от заданного значения.'
                        )
                },
                // Список функций-проверок
                checks = {
                    'rmp-counters-decrease-setup': function(data) {
                        return data.decrease_setup;
                    },
                    'rmp-counters-apps-count': function(data) {
                        return data.apps_count;
                    },
                    'rmp-counters-cpi-deviation':  function(data) {
                        return data.cpi_deviation;
                    },
                    'rmp-counters-setup-deviation': function(data) {
                        return data.setup_deviation;
                    },
                    'rmp-counters-no-cpi-data': function(data) {
                        return !data.allow_autobudget_avg_cpi
                    }
                };

            u._.forOwn(checks, function(check, name) {
                if (check(rmpCountersData)) {
                    errorCode = name;

                    return false;
                }
            });

            return errorCode ? warnings[errorCode] : '';
        },

        validation: {
            validate: function() {
                return this.get('rmpCounters').allow_autobudget_avg_cpi == 1;
            },
            text: {
                value: (u.consts('isTechInAppEventsInRmpEnabled') || u.consts('isUserInAppEventsInRmpEnabled')) ?
                    iget2(
                        'b-strategy2-settings',
                        'unable-to-setup-optimize-conversions',
                        'Невозможно подключить оптимизацию конверсий'
                    ) :
                    iget2(
                        'b-strategy2-settings',
                        'nevozmozhno-podklyuchit-srednyuyu-cenu-113',
                        'Невозможно подключить среднюю цену установки приложения'
                    ),
                only: true
            }
        }
    },

    isTrackUrlNeeded: 'boolean',

    // признак того, что средняя цена установки устанавливается из-вне попапа
    // (на странице создания РМП кампании)
    external: {
        type: 'boolean',
        default: false
    },

    mobileAppHasTrackUrl: {
        type: 'boolean',

        validation: {
            validate: function() {
                return this.get('mobileAppHasTrackUrl');
            },
            needToValidate: function() {
                return !!this.get('isTrackUrlNeeded') && !!this.get('cpi');
            },
            text: {
                value: iget2(
                    'b-strategy2-settings',
                    'mobile-app-has-not-tracker',
                    'Для работы стратегии необходимо подключить мобильную трекинговую систему и указать трекинговую ссылку в настройках приложения. {link}', {
                        link: {
                            block: 'link',
                            attrs: {
                                target: '_blank'
                            },
                            url: u.formatUrl({
                                path: '/registered/main.pl/mobile-apps/list',
                                query: {
                                    cmd: 'appList',
                                    ulogin: u.consts('ulogin')
                                }
                            }),
                            content: iget2('b-strategy2-settings', 'edit-url', 'Перейти к списку приложений')
                        }
                    }
                ),
                only: true
            }
        }

    },

    goalId: 'string',

    name: {
        type: 'string',
        calculate: function() {
            return !!this.get('cpi') ? u.strategy.AUTOBUDGET_AVG_CPI : u.strategy.AUTOBUDGET;
        },
        dependsFrom: ['cpi']
    },

    disabledGoalSelect: {
        type: 'boolean',
        calculate: function() {
            return this.get('name') === u.strategy.AUTOBUDGET;
        },
        dependsFrom: ['name']
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            var isCpaPayForConversionEnabled = this.get('isCpaPayForConversionEnabled');

            var options = {
                bid: (!isCpaPayForConversionEnabled && this.get('maxClickBidEnabled')) ? this.get('maxClickBid') : '',
                sum: this.get('weekBid') || '',
                goal_id: u.strategy.MOBILE_CPA_GOAL_ID
            };

            if (this.get('name') === u.strategy.AUTOBUDGET_AVG_CPI) {
                options.avg_cpi = this.get('cpi');
                options.goal_id = this.get('goalId');
                options.pay_for_conversion = isCpaPayForConversionEnabled ? 1 : 0
            }

            return options;
        }
    }
});
