/**
 * Шаблон для стратегии "Ручное управление ставками" для cpm_banner кампаний
 * {Object} ctx.modelData – модель стратегии
 * {Object} ctx.modelData.dayBudgetSettings – данные девного бюджета
 */
block('b-strategy2-settings').mod('name', 'cpm-default')(

    def()(function() {
        this.modelData = this.ctx.modelData || {};

        return applyNext();
    }),

    mode('model')('b-strategy2-settings_name_cpm-default'),

    elem('control').content()(function() {
        var dbSettings = this.modelData.dayBudgetSettings;

        return [
            {
                elem: 'day-budget-settings',
                elemMods: {
                    visible: 'yes',
                    bordered: 'top'
                },
                content: [
                    {
                        block: 'b-day-budget2-settings',
                        js: {
                            modelName: 'b-day-budget2-settings_name_cpm'
                        },
                        mods: {
                            name: 'cpm'
                        },
                        mix: { block: 'b-strategy2-settings', elem: 'day-budget' },
                        currency: dbSettings.currency,
                        maxDailyChangeCount: dbSettings.maxDailyChangeCount,
                        timesChangedToday: dbSettings.timesChangedToday,
                        isSet: dbSettings.isSet,
                        showMode: dbSettings.showMode,
                        sum: dbSettings.sum,
                        needHelpLink: dbSettings.needHelpLink
                    }
                ]
            }
        ]
    })
);
