/**
 * Панель настроек стратегии "Ручное управление ставками" для cpm_banner кампаний
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'cpm-default' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._dayBudget = this.findBlockInside('b-day-budget2-settings');
        }
    },

    /**
     * пробрасывает события дневного бюджета для его кеширования в блоке дневного бюджета
     */
    setDayBudgetEvent: function(event) {
        this._dayBudget.setOnMaximumClicksExceededEvent(event);
    },

    /**
     * Определяет доступность дневного бюджета
     * @returns {Boolean}
     */
    isDayBudgetEnabled: function() {

        return this.params.modelData.dayBudgetSettings.isEnabled;
    },

    /**
     * Валидирует форму, возвращает результат валидации и отображает ошибки
     * @returns {Boolean}
     * @override;
     */
    validate: function() {

        return this._dayBudget.validate();
    },

    /**
     * Очищает сообщения об ошибка валидации
     * @override;
     */
    clearErrorMessages: function() {
        this._dayBudget.clearErrorMessages();
    }
});
