/**
 * Модель стратегии «Снижение цены повторных показов»
 */
BEM.MODEL.decl({
    model: 'b-strategy2-settings_name_cpm-max-coverage',
    baseModel: 'b-strategy2-settings_type_cpm-auto'
}, {

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('decrease-price-for-repeat-impressions');
        }
    },

    name: {
        type: 'string',
        dependsFrom: ['spendMode'],
        calculate: function(mode) {
            return {
                period: 'autobudget_max_reach_custom_period',
                week: 'autobudget_max_reach'
            }[mode];
        }
    }

});
