/**
 * Модель стратегии «Максимум показов по минимальной цене»
 */
BEM.MODEL.decl({
    model: 'b-strategy2-settings_name_cpm-max-shows',
    baseModel: 'b-strategy2-settings_type_cpm-auto'
}, {

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('maximize-impressions-for-lowest-price');
        }
    },

    name: {
        type: 'string',
        dependsFrom: ['spendMode'],
        calculate: function(mode) {
            return {
                period: 'autobudget_max_impressions_custom_period',
                week: 'autobudget_max_impressions'
            }[mode];
        }
    }

});
