/**
 * Шаблон для стратегии "Ручное управление ставками"
 * {Object} ctx.modelData – данные модели
 * Описание данных см. в b-strategy2-choose: __getSettingData
 */
block('b-strategy2-settings').mod('name', 'max-clicks')(
  def()(function () {
      var dmData = this.ctx.modelData || {},
          vmData = {},
          options = dmData.options,
          isDynamic = dmData.mediaType === 'dynamic',
          isDefault = options.name === 'default',
          isDifferentPlaces = isDynamic ?
              false :
              !isDefault;

      u._.assign(vmData, dmData, {
          isDifferentPlaces: dmData.platform === 'search' ? false : isDifferentPlaces,
          contextLimit: isDefault ? this.ctx.contextLimit : 100,
          enable_cpc_hold: isDefault ? this.ctx.enable_cpc_hold : 1
      });

      return applyNext({
          modelData: vmData,
          walletInfo: this.ctx.walletInfo || {}
      });
  }),

  mode('model')('b-strategy2-settings_name_max-clicks'),

  content()(function () {
      var modelData = this.modelData,
          isDifferentPlaces = modelData.isDifferentPlaces,
          mediaType = modelData.mediaType,
          platform = modelData.platform,
          wasDifferentPlaces = modelData.savedName === u.strategy.MAXIMUM_CLICKS && isDifferentPlaces,
          hintContent = u['b-strategy2-settings_name_max-clicks'].getHintContent(mediaType, platform, isDifferentPlaces, wasDifferentPlaces);

      return [
          applyNext(),
          {
              block: 'b-strategy2-settings',
              elemMods: {
                  visible: hintContent ? 'yes' : 'no'
              },
              elem: 'strategy-hints',
              content: hintContent
          }
      ];
  }),

  elem('control').content()(function () {
      var modelData = this.modelData,
          dbSettings = modelData.dayBudgetSettings,
          range = [100, 90, 80, 70, 60, 50, 40, 30, 20, 10],
          contextLimit = modelData.contextLimit,
          isDifferentPlaces = modelData.isDifferentPlaces,
          enable_cpc_hold = modelData.enable_cpc_hold;

      return [
          {
              block: 'b-strategy2-settings-row',
              mix: [
                  {block: 'b-strategy2-settings', elem: 'different-places'},
                  {block: 'b-strategy2-settings', elem: 'row'}
              ],
              content: {
                  block: 'checkbox',
                  mods: {size: 's', checked: isDifferentPlaces ? 'yes' : ''},
                  name: 'different-places',
                  mix: [
                      {
                          block: 'b-strategy2-settings',
                          elem: 'model-field',
                          js: {
                              name: 'isDifferentPlaces',
                              type: 'checkbox'
                          }
                      }
                  ],
                  text: iget2('b-strategy2-settings', 'razdelno-upravlyat-stavkami-na', 'Раздельно управлять ставками на поиске и в сетях')
              }
          },
          dbSettings.isEnabled && {
              elem: 'day-budget-settings',
              elemMods: {
                  bordered: 'top',
                  greyed: dbSettings.isSet ? '' : 'yes'
              },
              content: {
                  block: 'b-day-budget2-settings',
                  mix: [{block: 'b-strategy2-settings', elem: 'day-budget'}],
                  currency: dbSettings.currency,
                  maxDailyChangeCount: dbSettings.maxDailyChangeCount,
                  timesChangedToday: dbSettings.timesChangedToday,
                  isSet: dbSettings.isSet,
                  showMode: dbSettings.showMode,
                  sum: dbSettings.sum,
                  needHelpLink: dbSettings.needHelpLink,
                  walletInfo: this.walletInfo
              }
          },
          {
              block: 'b-strategy2-settings-row',
              mix: [
                  {block: 'b-strategy2-settings', elem: 'context-limit'},
                  {block: 'b-strategy2-settings', elem: 'row'}
              ],
              content: iget2('b-strategy2-settings', 'context-limit', 'Тратить на показы в сетях до {percentage} от общего расхода кампании', {
                  percentage: {
                      block: 'select',
                      mix: [{
                          block: 'b-strategy2-settings',
                          elem: 'context-limit-select'
                      }, {
                          block: 'b-strategy2-settings',
                          elem: 'model-field',
                          js: [{
                              name: 'contextLimit',
                              type: 'select'
                          }]
                      }],
                      content: [
                          {
                              block: 'button',
                              content: contextLimit + '%'
                          },
                          {
                              elem: 'control',
                              content: range.map(function (val) {
                                  var option = {
                                      elem: 'option',
                                      attrs: { value: val },
                                      content: val + '%'
                                  };

                                  if (val === contextLimit) {
                                      option.attrs.selected = 'selected';
                                  }

                                  return option;
                              })
                          }
                      ]
                  }
              }),
          },
          {
              block: 'b-strategy2-settings-row',
              mix: [
                  {block: 'b-strategy2-settings', elem: 'cpc-hold'},
                  {block: 'b-strategy2-settings', elem: 'row'}
              ],
              content: {
                  block: 'checkbox',
                  mods: {size: 's', checked: enable_cpc_hold ? 'yes' : ''},
                  name: 'different-places',
                  mix: [
                      {
                          block: 'b-strategy2-settings',
                          elem: 'model-field',
                          js: {
                              name: 'enable_cpc_hold',
                              type: 'checkbox'
                          }
                      }
                  ],
                  text: iget2('b-strategy2-settings', 'enable-cpc-hold', 'Удерживать среднюю стоимость клика в сетях ниже, чем на поиске')
              }
          }
      ];
  })
);
