/**
 * Панель настроек стратегии "Ручное управление ставками"
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'max-clicks' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // это не dataModel, а просто хэш параметров!
            this._modelData = this.params.modelData;

            this._differentPlaces = this.findBlockInside('different-places', 'b-strategy2-settings-row');
            this._contextLimit = this.findBlockOn('context-limit', 'b-strategy2-settings-row');
            this._cpcHold = this.findBlockOn('cpc-hold', 'b-strategy2-settings-row');
            this._needHints = this.params.needHints || false;
            this._subscriptionManager = BEM.create('i-subscription-manager');
            this._wasDifferentPlaces = this._modelData.savedName === u.strategy.MAXIMUM_CLICKS && this._modelData.isDifferentPlaces;

            if (this.isDayBudgetEnabled()) {
                this._dayBudget = this.findBlockInside('b-day-budget2-settings');
                this._subscriptionManager.on(this._dayBudget, 'change', this._onDayBudgetChange, this);
            }

            this._subscriptionManager.wrap(this.model)
                .on('isDifferentPlaces', 'change', function(e, data) {
                    this._updateWarnings(this._modelData.mediaType, this.model.get('platform'), data.value);
                    this._contextLimit && this._contextLimit.setMod('visible', data.value ? 'no' : 'yes');
                    this._cpcHold && this._cpcHold.setMod('visible', data.value ? 'no' : 'yes');
                }, this);

            this._updateWarnings(this._modelData.mediaType, this._modelData.platform, this.model.get('isDifferentPlaces'));

            this._updateTitle(this._modelData.platform);
        },

        //  включаем галочки в зависимости от платформы
        platform: function(modName, modValue) {
            var isDynamic = this.model.get('mediaType') === 'dynamic';

            // при смене платформы isChanged: true вернет chooser,
            // поэтому можно сделать fix (иначе при первом же открытии isChanged вернется true)
            this.model.set('platform', modValue).fix();
            switch (modValue) {
                case u.strategy.ALL:
                    // для ДТО нельзя раздельно управлять ставками на поиске и в сетях
                    this._differentPlaces.setMod('visible', !isDynamic ? 'yes' : 'no');
                    this._contextLimit && this._contextLimit.setMod('visible', (!this.model.get('isDifferentPlaces')) ? 'yes' : 'no');
                    this._cpcHold && this._cpcHold.setMod('visible', (!this.model.get('isDifferentPlaces')) ? 'yes' : 'no');
                    break;
                case u.strategy.SEARCH:
                    this.model.set('platform', u.strategy.SEARCH);
                    // убираем раздельное управление
                    this._differentPlaces.setMod('visible', 'no');
                    this._contextLimit && this._contextLimit.setMod('visible', 'no');
                    this._cpcHold && this._cpcHold.setMod('visible', 'no');
                    break;
                case u.strategy.NET:
                    this.model.set('platform', u.strategy.NET);
                    // убираем раздельное управление
                    this._differentPlaces.setMod('visible', 'no');
                    this._contextLimit && this._contextLimit.setMod('visible', 'no');
                    this._cpcHold && this._cpcHold.setMod('visible', 'no');
                    break;
                default: break;
            }
            this._updateDescription(modValue);
            this._updateTitle(modValue);
            this._updateWarnings(this.model.get('mediaType'), modValue, this.model.get('isDifferentPlaces'));
        }
    },

    /**
     * кеширует и пробрасывает события дневного бюджета,
     * которые пробрасываются из директа/коммандера
     */
    setDayBudgetEvent: function(event) {
        this._dayBudget.setOnMaximumClicksExceededEvent(event);
    },

    /**
     * Определяет доступность дневного бюджета
     * @returns {Boolean}
     */
    isDayBudgetEnabled: function() {
        return this._modelData.dayBudgetSettings.isEnabled;
    },

    /**
     * Определяет доступность ограничения бюджета на показы в РСЯ
     * @returns {Boolean}
     */
    isContextLimitEnabled: function() {
        return this.model.get('platform') === 'all' && !this.model.get('isDifferentPlaces');
    },

    /**
     * Ограничение бюджета на показы в РСЯ (в процентах)
     * @returns {Number}
     */
    getContextLimit: function() {
        return this.model.get('contextLimit');
    },

    /**
     * Параметр "Удерживать среднюю ставку ниже средней ставки на поиске"
     * @returns {Number}
     */
    getEnableCpcHold: function() {
        return this.model.get('enable_cpc_hold') ? 1 : 0;
    },

    /**
     * Возвращает данные для маппинга новой стратегии в старые
     * @param {String} platform - текущая платформа
     * @returns {{name: string, options: {}}} - данные: имя плюс опции
     */
    getOptions: function(platform) {
        // у сетевой стратегии настроек нет
        if (platform == u.strategy.NET){
            return { name: u.strategy.MAXIMUM_COVERAGE, options: { } };
        }

        var data = { name: '', options: { } },
            isDifferentPlaces = platform == u.strategy.SEARCH ? false : this.model.get('isDifferentPlaces'),
            mappedData = { name: u.strategy.DEFAULT };

        if (isDifferentPlaces){
            data.name = u.strategy.DIFFERENT_PLACES;
            // при раздельном управлении в сетях всегда максимальный охват
            data.options.net = { name: u.strategy.MAXIMUM_COVERAGE };
            // а на поиске - по результам маппинга
            data.options.search = mappedData;
        } else {
            // при нераздельном ставим по результатам маппинга всегда
            data.name = mappedData.name;
            mappedData.place ? data.options.place = mappedData.place : '';
        }

        return data;
    },

    /**
     * Валидирует форму, возвращает результат валидации и отображает ошибки
     * @returns {Boolean}
     * @override;
     */
    validate: function() {
        return this.findBlocksInside(this.domElem.children(), 'b-strategy2-settings').reduce(function(accum, block) {
            return accum && block.validate();
        }, true);
    },

    /**
     * Очищает сообщения об ошибка валидации
     * @override;
     */
    clearErrorMessages: function() {
        this.findBlocksInside(this.domElem.children(), 'b-strategy2-settings').forEach(function(block) {
            block.clearErrorMessages();
        });
    },

    /**
    * Деструктор
    * @override;
    */
    destruct: function() {
        this._subscriptionManager.dispose();
        return this.__base.apply(this, arguments);
    },

    _updateTitle: function(platform) {
        var title = u.strategy.getTitleByName(this._modelData.name, platform, this.params.campaignType, {}, this.params.isChangeManualStrategyName);
        this.elem('title-text').text(title);
    },

    /**
     * Перерисовывает подсказку для текущей стратегии
     * @param mediaType {String} тип кампании
     * @param platform {String} места показов
     * @param differentPlaces {boolean} выбрано ли раздельноу управление ставками
     * @returns {String}
     */
    _updateWarnings: function(mediaType, platform, differentPlaces) {
        var hintContent = BEMHTML.apply(u['b-strategy2-settings_name_max-clicks'].getHintContent(mediaType, platform, differentPlaces, this._wasDifferentPlaces));

        BEM.DOM.update(
            this.elem('strategy-hints'),
            hintContent
        );

        this.setMod(this.elem('strategy-hints'), 'visible', hintContent ? 'yes' : 'no');
    },

    /**
     * Обновляет описание стратеии в зависимости от платформы
     * @param {String} platform
     * @private
     */
    _updateDescription: function(platform) {
        this._needHints && BEM.DOM.update(
            this.elem('description'),
            BEMHTML.apply({
                content: u.strategy.getStrategyDescription({
                    name: u.strategy.MAXIMUM_CLICKS,
                    platform: platform
                })
            })
        );
    },

    _onDayBudgetChange: function(e, data) {
        this.setMod(this.elem('day-budget-settings'), 'greyed', data.active ? '' : 'yes');
    }
});
