u.register({

    'b-strategy2-settings_name_max-clicks': {
        /**
         *
         * @param mediaType {String} тип кампании
         * @param platform {String} места показов
         * @param differentPlaces {boolean} выбрано ли раздельное управление ставками
         * @param wasDifferentPlaces {boolean} было ли сохранено раздельное управление
         * @return {BEMJSON}
         */
        getHintContent: function(mediaType, platform, differentPlaces, wasDifferentPlaces) {
            var text;

            if (platform !== u.strategy.ALL) {
                return null;
            }

            if (!wasDifferentPlaces && differentPlaces) {
                text = iget2(
                    'b-strategy2-settings',
                    'pri-sohranenii-strategii-ceny',
                    'При сохранении стратегии цены в сетях будут проставлены в зависимости от максимальной цены на поиске. Изменить цены в сетях можно со страницы кампании.'
                );
            }

            return text ? [
                {
                    block: 'icon',
                    mods: {'size-13': 'alert'},
                    mix: {
                        block: 'b-strategy2-settings',
                        elem: 'hint-icon'
                    }
                },
                text
            ] : null;
        }
    }

});
