/**
 * Модель стратегии "Ручное управление ставками"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_max-clicks', baseModel: 'b-strategy2-settings' }, {

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('manual-strategy') || '';
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            return {};
        }
    },

    //платформа - не изменяется
    platform: {
        type: 'string',
        enum: [
            'search',
            'all',
            'net'
        ]
    },

    // раздельное управление ставками на поиске и в сетях
    isDifferentPlaces: {
        type: 'boolean'
    },

    // ограничение расхода на показы в сетях
    contextLimit: {
        type: 'blank-number',
        precision: 0
    },

    // удерживать среднюю ставку ниже средней ставки на поиске
    enable_cpc_hold:  {
        type: 'boolean'
    }
});
