/**
 * Блок настроек стратегии Оптимизация количества конверсии
 * {String} ctx.modelData – данные модели
 * {String} ctx.modelData.target - вид сущности для которой выполняется оптимизация (camp или filter)
 * {String} ctx.modelData.originName - имя стратегии на сервесайде
 * {String} ctx.modelData.isNewCamp - является ли кампания новой
 * {String} ctx.modelData.now_optimizing_by - по какому из видов ставки (CPC или CPA) выполнена оптимизация
 * {String} ctx.modelData.goal_id - ID цели
 * {String} ctx.modelData.avg_cpa - CPA кампании
 * {String} ctx.modelData.filter_avg_cpa - CPA фильтра
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 */
block('b-strategy2-settings').mod('name', 'opt-cpa')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {};

        vmData.target = dmData.target || 'filter';
        vmData.originName = dmData.originName;
        vmData.isNewCamp = dmData.isNewCamp;
        vmData.optimizedBy = (dmData.now_optimizing_by || 'cpa').toLowerCase();
        vmData.goalId = (dmData.goal_id == u.consts('allKeyGoals') ? null : dmData.goal_id) || '';

        vmData.cpaPerCamp = dmData.avg_cpa;
        vmData.cpaPerFilter = dmData.filter_avg_cpa;

        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';
        vmData.isCpaPayForConversionsStrategyAllowed = dmData.isCpaPayForConversionsStrategyAllowed;
        vmData.isCpaPayForConversionEnabled = dmData.isCpaPayForConversionEnabled;

        vmData.minGoalsOnCampaign = dmData.minGoalsOnCampaign;

        return applyNext({
            'mods.target': vmData.target,
            modelData: vmData
        });
    }),

    mode('model')('b-strategy2-settings_name_opt-cpa'),

    elem('attribution-model-control').replace()(function() {
        return {
            block: 'b-strategy2-settings',
            elem: 'row',
            mix: {
                block: 'b-strategy2-settings',
                elem: 'model-field',
                js: {
                    name: 'disabledMetrika',
                    type: 'mod',
                    block: 'b-strategy2-settings',
                    elem: 'row',
                    modName: 'disabled'
                }
            },
            content: applyNext()
        };
    }),

    elem('control')(

        mix()({
            block: 'b-strategy2-settings',
            elem: 'model-field',
            js: {
                name: 'disabledMetrika',
                type: 'mod',
                block: 'b-strategy2-settings',
                elem: 'control',
                modName: 'disabled'
            }
        }),

        content()(function() {
            var modelData = this.modelData,
                currency = this.currency,
                isCpaPayForConversionsStrategyAllowed = modelData.isCpaPayForConversionsStrategyAllowed,
                isCpaPayForConversionEnabled = modelData.isCpaPayForConversionEnabled,
                goalsCount = modelData.metrika.campaign_goals.length;

                return [
                    isCpaPayForConversionsStrategyAllowed
                    && goalsCount !== 0
                    &&
                {
                    elem: 'row',
                    elemMods: {
                        'always-visible': 'yes'
                    },
                    content: [
                        {
                            block: 'checkbox',
                            mods: { checked: isCpaPayForConversionEnabled ? 'yes' : '' },
                            mix: [
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'isCpaPayForConversionEnabled',
                                        type: 'checkbox'
                                    }
                                },
                                {
                                    block: 'b-strategy2-settings',
                                    elem: 'checkbox-control'
                                }
                            ],
                            text: iget2('b-strategy2-settings', 'pay-for-conversions', 'Оплата за конверсии'),
                        },
                        {
                            block: 'b-help-link',
                            mix: [
                                {
                                    block: 'b-hintable-popup',
                                    js: {
                                        hint: iget2('b-strategy2-settings', 'hint-pay-for-conversion', "При включении опции «Оплата за конверсии» вы платите за каждое достижение указанного вами целевого визита."),
                                        directions: ['bottom','right'],
                                        mixPopup: { block: 'b-strategy2-settings', elem: 'popup-conversion-hint' }
                                    }
                                }
                            ]
                        }
                    ]
                },
                u.consts('failedToFetchMetrika') && {
                    elem: 'row',
                    content: {
                        block: 'b-metrika-unavailable-warning'
                    }
                },
                {
                    elem: 'row',
                    content: [
                        iget2('b-strategy2-settings', 'po-celi', 'По цели:'),
                        '&nbsp;',
                        {
                            elem: 'goal-select-special',
                            metrikaGoals: u.strategy.convertGoalsToSpecial(modelData.metrika.campaign_goals),
                            currentGoalId: modelData.goalId,
                            disableAllGoalsOption: true
                        },
                        {
                            elem: 'goal-select',
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'goal-select'
                            },
                            metrikaGoals: modelData.metrika.campaign_goals,
                            disableAllGoalsOption: true,
                            where: modelData.where,
                            currentGoalId: modelData.goalId,
                            minGoalsOnCampaign: modelData.minGoalsOnCampaign
                        },
                        {
                            elem: 'radio-button',
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'radio-button-all'
                            },
                            fieldName: 'target',
                            options: u['b-strategy2-settings_name_opt-cpa'].targets,
                            optionsLabels: u['b-strategy2-settings_name_opt-cpa'].targetsText,
                            value: modelData.target
                        },
                        {
                            elem: 'radio-button',
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'radio-button-special'
                            },
                            fieldName: 'target',
                            options: u['b-strategy2-settings_name_opt-cpa'].targetsCpaPayForConversions,
                            optionsLabels: u['b-strategy2-settings_name_opt-cpa'].targetsTextCpaPayForConversions,
                            value: modelData.target
                        },

                    ]
                },
                {
                    elem: 'row',
                    elemMods: {
                        separate: 'yes'
                    },
                        content: iget2('b-strategy2-settings', 'label-input-v-srednem-week', '{label} {input} {week} {hint}', {
                        label: {
                            block: 'b-strategy2-settings',
                            elem: 'input-wrap-label',
                            tag: 'span',
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'label',
                                    type: 'inline'
                                }
                            },
                            content: u['b-strategy2-settings_name_opt-cpa'].labels[modelData.target]
                        },

                        week: {
                            elem: 'input-cpa-week-text',
                            content: iget2('b-strategy2-settings', 'v-srednem-week-cpc-cpa', 'в среднем за неделю')
                        },

                        input: {
                            elem: 'input-wrap',
                            content: u['b-strategy2-settings_name_opt-cpa'].types.map(function(item) {

                                return ['PerFilter', 'PerCamp'].map(function(target) {

                                    return {
                                        elem: 'input-wrap-row',
                                        elemMods: {
                                            type: item == modelData.optimizedBy && 'marked',
                                            name: u.beminize(target)
                                        },
                                        mix: [
                                            {
                                                elem: item + '-' + modelData.target + '-input-wrap'
                                            }
                                        ],
                                        content: [
                                            {
                                                elem: 'input-label',
                                                mix: {
                                                    block: 'b-strategy2-settings',
                                                    elem: 'model-field',
                                                    js: {
                                                        name: item + 'Label',
                                                        type: 'inline'
                                                    }
                                                },
                                                content: u['b-strategy2-settings_name_opt-cpa'].rateLabel[item][modelData.target]
                                            },
                                            {
                                                block: 'input',
                                                mods: { clear: 'no' },
                                                mix: [
                                                    {
                                                        block: 'b-strategy2-settings',
                                                        elem: 'model-field',
                                                        js: {
                                                            name: item + target,
                                                            type: 'formatted-input'
                                                        }
                                                    },
                                                    {
                                                        block: 'b-strategy2-settings',
                                                        elem: 'input-control',
                                                        elemMods: { field: item + target }
                                                    }
                                                ],
                                                value: modelData[item + target] ?
                                                    u.numberFormatter.roundFormatted(modelData[item + target], {
                                                        precision: 2,
                                                        fail: ''
                                                    }) :
                                                    '',
                                                content: { elem: 'control' }
                                            },
                                            {
                                                elem: 'input-label',
                                                content: currency
                                            }
                                    ]
                                    };
                                });
                            })
                        },

                        hint: {
                            block: 'b-strategy2-settings',
                            elem: 'input-wrap-hint',
                            mix: {
                                block: 'b-strategy2-settings',
                                elem: 'model-field',
                                js: {
                                    name: 'hint',
                                    type: 'inline'
                                }
                            },
                            content: u['b-strategy2-settings_name_opt-cpa'].hints[modelData.target]
                        }
                    })
                },
                {
                    elem: 'week-bid-control',
                    weekBidEnabled: modelData.weekBidEnabled,
                    weekBid: modelData.weekBid,
                    currency: modelData.currency,
                    isReadOnly: modelData.isReadOnly
                },
                {
                    elem: 'max-click-bid-control',
                    maxClickBidEnabled: modelData.maxClickBidEnabled,
                    maxClickBid: modelData.maxClickBid,
                    currency: modelData.currency,
                    isReadOnly: modelData.isReadOnly
                },
                {
                    elem: 'metrika-warning'
                }
            ];
        })
    )
);
