BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'opt-cpa' }, {
    onSetMod: {
        js: function() {
            this.__base();

            var goals = this.model.get('metrika').campaign_goals,
                maxBidControl = this.findElem('max-click-bid-control'),
                isCpaPayForConversionEnabled = this.model.get('isCpaPayForConversionEnabled');

            this.model.on('target', 'change', function(e, data) {
                this
                    .setMod('target', data.value)
                    .clearErrorMessages();
            }, this);

            this.model.on('isCpaPayForConversionEnabled', 'change', this._changeControlVisibilityOpt, this);
            this._listenToPayForConversionFlag();

             this.setMod(maxBidControl, 'visible', goals.length === 0 || isCpaPayForConversionEnabled ? 'no' : 'yes');

            this._setCpaFilter(isCpaPayForConversionEnabled);
        },

        show: function() {
            this.model.set('where', 'context').fix();
            this._updateMetrika('default');
        }
    },

    /**
     * Посвечивает или снимает подсветку _error_yes с поля в зависимости от состояния
     * @param {String} field
     * @param {Boolean} [state=true]
     * @override
     */
    highlightErrorField: function(field, state) {
        var input = this._getControlInput(field);

        input && input.toggleMod('error', 'yes', typeof state == 'boolean' ? state : true);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this.model.un('target', 'change');
        this.__base.apply(this, arguments);
    },

    /**
     * Очищает сообщения об ошибках и снимает подсветку с полей с ошибками
     * @override
     */
    clearErrorMessages: function() {
        ['cpaPerCamp', 'cpaPerFilter', 'weekBid', 'maxClickBid'].forEach(function(field) {
            this.highlightErrorField(field, false);
        }, this);

        return this.__base.apply(this, arguments);
    },

    /**
     * Возвращает блок поля ввода связанный с полем модели
     * @param {String} field
     * @returns {BEM.DOM<input>}
     * @private
     */
    _getControlInput: function(field) {
        var control = this.elem('input-control', 'field', field);

        return this.findBlockOn(control, 'input');
    },

    _changeControlVisibilityOpt: function(e, data) {
        this._changeControlVisibility(e, data);
        this.model.set('target', 'filter');
        this.model.set('target', 'camp');
        this._setCpaFilter(data.value);
    },

    _setCpaFilter: function(isCpaPayForConversionEnabled) {
        var radioButton = this.findElem('radio-button-all'),
            cpcControl = this.findElem('cpc-filter-input-wrap'),
            cpcCampInput = this.findElem('cpc-camp-input-wrap'),
            hint = this.findElem('input-wrap-hint'),
            payForWeekText = this.findElem('input-cpa-week-text'),
            domElem = this.domElem,
            radioButtonSpecial = this.findElem('radio-button-special');

        if (isCpaPayForConversionEnabled) {
            this.setMod(domElem, 'pay-for-conversions', 'yes');
        } else {
            this.setMod(domElem, 'pay-for-conversions', 'no');
        }
    },

    isCpaPayForConversionEnabled: function() {
        return this.model.get('isCpaPayForConversionEnabled');
    },

    _updateGoalsSelect: function() {

    }
});
