/**
 * Модель стратегии "Оптимизация количества конверсий"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_opt-cpa', baseModel: 'b-strategy2-settings_media-type_performance' }, {
    /**
     * переопределить лишние поля из родительской модели
     */
    cpcPerCamp: {},
    cpcPerFilter: {},

    /**
     * тип (CPA) по которому выполнена оптимизация
     */
    optimizedBy: {
        type: 'enum',
        'default': 'cpa',
        'enum': u['b-strategy2-settings_name_opt-cpa'].types
    },

    /**
     * CPA для кампании
     */
    cpaPerCamp: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                gte: {
                    needToValidate: function(val) {
                        return !!val && this._isCamp();
                    },
                    value: function() {
                        var maxCpa = this.get('isCpaPayForConversionEnabled')
                            ? u.consts('increasedCpaLimitForPayForConversion')
                                ? 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED'
                                : 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING'
                            : 'MAX_PRICE';
                        return u.currencies.getConst(this.get('currency'), maxCpa);
                    },
                    text: function() {
                        var maxCpa = this.get('isCpaPayForConversionEnabled')
                            ? u.consts('increasedCpaLimitForPayForConversion')
                                ? 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING_INCREASED'
                                : 'AUTOBUDGET_PAY_FOR_CONVERSION_AVG_CPA_WARNING'
                            : 'MAX_PRICE';
                        return iget2('b-strategy2-settings', 'srednyaya-cena-konversii-ne', 'Средняя цена конверсии не может быть больше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), maxCpa)
                        });
                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'srednyaya-cena-konversii-dolzhna',
                            'Средняя цена конверсии должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                            }
                        );
                    },
                    needToValidate: function(val) {
                        return !!val && this._isCamp();
                    }
                },
                required: {
                    needToValidate: function() {
                        return this._isCamp();
                    },
                    validate: function(val) { return !!val },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-108', 'Не указано значение средней цены конверсии');
                    }
                },
            }
        }
    },

    /**
     * CPA для фильтра
     */
    cpaPerFilter: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: {
                    needToValidate: function() {
                        return this._isFilter();
                    },
                    validate: function(val) { return !!val },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ne-ukazano-znachenie-sredney-108', 'Не указано значение средней цены конверсии');
                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'srednyaya-cena-konversii-dolzhna',
                            'Средняя цена конверсии должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                            }
                        );
                    },
                    needToValidate: function(val) {
                        return !!val && this._isFilter();
                    }
                },
                gte: {
                    needToValidate: function(val) {
                        return !!val && this._isFilter();
                    },
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_PRICE');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'srednyaya-cena-konversii-ne', 'Средняя цена конверсии не может быть больше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_PRICE')
                        });
                    }
                }
            }
        }
    },

    /**
     * Предупреждения метрики
     */
    metrikaWarning: {
        type: 'object',
        dependsFrom: ['goalId', 'where', 'metrika'],
        calculate: function() {
            var data =  u['b-strategy2-settings'].getMetrikaWarningsText(this.get('name'), this.get('metrika'), this.get('goalId'), this.get('where'), this.get('metrikaCounter'));

            if (this.get('isCpaPayForConversionEnabled') && data.code === 'no-metrika-optional-visits') {
                return {};
            }

            return data;
        },
        validation: {
            validate: function() {
                return this.get('isCpaPayForConversionEnabled') || !this.get('disabledMetrika');
            },
            text: {
                value: iget2(
                    'b-strategy2-settings',
                    'pered-nastrojkoj-strategii-ukazhite-schetchik-metriki',
                    'Перед настройкой стратегии укажите счетчик Метрики и задайте ключевые цели кампании'
                ),
                only: true
            }
        }
    },

    /**
     * текст для лейбла у контрола ввода CPA
     */
    label: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return u['b-strategy2-settings_name_opt-cpa'].labels[target];
        }
    },

    /**
     * текст- сноска
     */
    hint: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return u['b-strategy2-settings_name_opt-cpa'].hints[target];
        }
    },

    /**
     * текст для лейбла у контрола ввода CPA
     */
    cpaLabel: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return u['b-strategy2-settings_name_opt-cpa'].rateLabel.cpa[target];
        }
    },

    /**
     * идентификатор цели в Метрике
     */
    goalId: {
        type: 'string',
        validation: {
            needToValidate: function() {
                return !this.get('disabledMetrika');
            },
            rules: {
                required: {
                    text: iget2('b-strategy2-settings', 'neobhodimo-vybrat-cel', 'Необходимо выбрать цель')
                }
            }
        }
    },

    /**
     * url ссылки на описание стратегии
     */
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('optimize-number-of-conversions') || '';
        }
    },

    /**
     * настройки стратегии
     */
    options: {
        type: 'object',
        calculate: function() {
            var payForConversionEnabled = this.get('isCpaPayForConversionEnabled');

            var resp = {
                originName: 'autobudget_avg_cpa_per_' + this.get('target'),
                target: this.get('target'),
                sum: this.get('weekBidEnabled') ? this.get('weekBid') : null,
                goal_id: this.get('goalId'),
                bid: !payForConversionEnabled && this.get('maxClickBidEnabled') ? this.get('maxClickBid') : null
            };

            if (this._isFilter()) {
                resp.filter_avg_cpa = this.get('cpaPerFilter') || null;
            }

            if (this._isCamp()) {
                resp.avg_cpa = this.get('cpaPerCamp') || null;
                resp.pay_for_conversion = payForConversionEnabled ? 1 : 0;
            }

            return resp;
        }
    },

    /**
     * Недельный бюджет
     */
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('weekBidEnabled');
            },
            rules: {
                min: {
                    value: function() {
                        return (this.get('isCpaPayForConversionEnabled') && this.get('cpaPerCamp')) ?
                            this.get('cpaPerCamp') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')
                            : 0
                    },
                    needToValidate: function() {
                        return (this.get('cpaPerCamp') * u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')) !== this.get('weekBid');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'check-that-week-budget-more-then-cpa', 'Недельный бюджет должен гарантировать покупку {foo} конверсий в неделю по целевому CPA', {
                            foo: u.consts('PAY_FOR_CONVERSION_SUM_TO_AVG_CPA_MIN_RATIO')
                        })
                    }
                },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                lowerClickPrice: {
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt', 'Недельный бюджет должен быть больше максимальной цены клика.'),
                    validate: function(val) {
                        return val > this.get('maxClickBid');
                    },
                    needToValidate: function(val) {
                        return !!val && this.get('maxClickBidEnabled');
                    }
                },
                lowerThenCPA: {
                    text: iget2(
                        'b-strategy2-settings',
                        'nedelnyy-byudzhet-dolzhen-byt-109',
                        'Недельный бюджет должен быть больше средней цены конверсии.'
                    ),
                    validate: function(val) {
                        return val > (this._isFilter() ? this.get('cpaPerFilter') : this.get('cpaPerCamp'));
                    },
                    needToValidate: function(val) {
                        return !!val && (this._isFilter() ? !!this.get('cpaPerFilter') : !!this.get('cpaPerCamp'));
                    }
                }
            }
        }
    }

});
