/**
 * Блок настроек стратегии Оптимизация количества кликов
 * {String} ctx.modelData – данные модели
 * {String} ctx.modelData.target - вид сущности для которой выполняется оптимизация (camp или filter)
 * {String} ctx.modelData.originName - имя стратегии на сервесайде
 * {String} ctx.modelData.isNewCamp - является ли кампания новой
 * {String} ctx.modelData.filter_avg_bid - CPC фильтра
 * {String} ctx.modelData.avg_bid - CPC кампании
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 */
block('b-strategy2-settings').mod('name', 'opt-cpc')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {},
            omitCpcPerFilter = ['mcbanner', 'content_promotion'].indexOf(dmData.mediaType) !== -1;

        vmData.target = omitCpcPerFilter ? 'camp' : (dmData.target || 'filter');
        vmData.originName = dmData.originName;
        vmData.isNewCamp = dmData.isNewCamp;

        vmData.cpcPerFilter = dmData.filter_avg_bid || '';
        vmData.cpcPerCamp = dmData.avg_bid || '';

        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';

        return applyNext({
            'mods.target': vmData.target,
            modelData: vmData
        });
    }),

    mode('model')('b-strategy2-settings_name_opt-cpc'),


    elem('control').content()(function() {
        var modelData = this.modelData,
            omitCpcPerFilter = ['mcbanner', 'content_promotion'].indexOf(modelData.mediaType) !== -1,
            inputNames = omitCpcPerFilter ? ['cpcPerCamp'] : ['cpcPerCamp', 'cpcPerFilter'],
            currency = this.currency;

        return [
            omitCpcPerFilter || {
                elem: 'row',
                content: {
                    elem: 'radio-button',
                    fieldName: 'target',
                    options: u['b-strategy2-settings_name_opt-cpc'].targets,
                    optionsLabels: u['b-strategy2-settings_name_opt-cpc'].targetsText,
                    value: modelData.target
                }
            },
            {
                elem: 'row',
                elemMods: { separate: 'yes' },
                content: iget2('b-strategy2-settings', 'label-input-v-srednem', '{label} {input} в среднем за неделю {hint}', {
                    label: {
                        block: 'b-strategy2-settings',
                        elem: 'input-wrap-label',
                        tag: 'span',
                        mix: {
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: 'label',
                                type: 'inline'
                            }
                        },
                        content: u['b-strategy2-settings_name_opt-cpc'].labels[modelData.target]
                    },

                    input: {
                        elem: 'input-wrap',
                        content: inputNames.map(function(item) {
                            return {
                                elem: 'input-wrap-row',
                                elemMods: { name: u.beminize(item) },
                                content: [
                                    {
                                        block: 'input',
                                        mods: { clear: 'no' },
                                        mix: [
                                            {
                                                block: 'b-strategy2-settings',
                                                elem: 'model-field',
                                                js: {
                                                    name: item,
                                                    type: 'formatted-input'
                                                }
                                            },
                                            {
                                                block: 'b-strategy2-settings',
                                                elem: 'input-control',
                                                elemMods: { field: item }
                                            }
                                        ],
                                        value: modelData[item] ?
                                            u.numberFormatter.roundFormatted(modelData[item], {
                                                precision: 2,
                                                fail: ''
                                            }) :
                                            '',
                                        content: { elem: 'control' }
                                    },
                                    {
                                        elem: 'input-label',
                                        content: currency
                                    }
                                ]
                            };
                        })
                    },

                    hint: {
                        block: 'b-strategy2-settings',
                        elem: 'input-wrap-hint',
                        mix: {
                            block: 'b-strategy2-settings',
                            elem: 'model-field',
                            js: {
                                name: 'hint',
                                type: 'inline'
                            }
                        },
                        content: u['b-strategy2-settings_name_opt-cpc'].hints[modelData.target]
                    }
                })
            },
            {
                elem: 'week-bid-control',
                weekBidEnabled: modelData.weekBidEnabled,
                weekBid: modelData.weekBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },
            {
                elem: 'max-click-bid-control',
                maxClickBidEnabled: modelData.maxClickBidEnabled,
                maxClickBid: modelData.maxClickBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            }
        ];
    })
);
