BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'opt-cpc' }, {
    onSetMod: {
        js: function() {
            this.__base();

            this.model.on('target', 'change', function(e, data) {
                this
                    .setMod('target', data.value)
                    .clearErrorMessages();
            }, this);
        }
    },

    /**
     * Посвечивает или снимает подсветку _error_yes с поля в зависимости от состояния
     * @param {String} field
     * @param {Boolean} [state=true]
     * @override
     */
    highlightErrorField: function(field, state) {
        var input = this._getControlInput(field);

        input && input.toggleMod('error', 'yes', typeof state == 'boolean' ? state : true);
    },

    /**
     * Очищает сообщения об ошибках и снимает подсветку с полей с ошибками
     * @override
     */
    clearErrorMessages: function() {
        ['cpcPerCamp', 'cpcPerFilter', 'weekBid', 'maxClickBid'].forEach(function(field) {
            this.highlightErrorField(field, false);
        }, this);

        return this.__base.apply(this, arguments);
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this.model.un('target', 'change');
        this.__base.apply(this, arguments);
    },

    /**
     * Возвращает блок поля ввода связанный с полем модели
     * @param {String} field
     * @returns {BEM.DOM<input>}
     * @private
     */
    _getControlInput: function(field) {
        var control = this.elem('input-control', 'field', field);

        return this.findBlockOn(control, 'input');
    }

});
