/**
 * Модель стратегии "Оптимизация количества кликов"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_opt-cpc', baseModel: 'b-strategy2-settings_media-type_performance' }, {
    /**
     * текст для лейбла у контрола ввода CPC
     */
    label: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return u['b-strategy2-settings_name_opt-cpc'].labels[target];
        }
    },

    /**
     * текст- сноска
     */
    hint: {
        type: 'string',
        dependsFrom: ['target'],
        calculate: function(target) {
            return u['b-strategy2-settings_name_opt-cpc'].hints[target];
        }
    },

    /**
     * url ссылки на описание стратегии
     */
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('optimize-number-of-clicks') || '';
        }
    },

    /**
     * настройки стратегии
     */
    options: {
        type: 'object',
        calculate: function() {
            var resp = {
                originName: 'autobudget_avg_cpc_per_' + this.get('target'),
                target: this.get('target'),
                bid: this.get('maxClickBidEnabled') ? this.get('maxClickBid') : null,
                sum: this.get('weekBidEnabled') ? this.get('weekBid') : null
            };

            this._isFilter() && (resp.filter_avg_bid = this.get('cpcPerFilter') || null);
            this._isCamp() && (resp.avg_bid = this.get('cpcPerCamp') || null);

            return resp;
        }
    }
});
