/**
 * Блок настроек стратегии Средняя рентабельность инвестиций
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.profitability – себестоимость
 * {String} ctx.modelData.reserve_return – возвращать в рекламу
 * {String} ctx.modelData.goal_id – id цели Метрики
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 * {String} ctx.modelData.roi_coef – коэффициент рентабельности
 */
block('b-strategy2-settings').mod('name', 'roi')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {},
            rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(dmData.mediaType),
            failedToFetchMetrika = u.consts('failedToFetchMetrika'),
            defaultGoalId = undefined;

        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';
        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.profitabilityEnabled = !!dmData.profitability;
        vmData.weekBidEnabled = !!dmData.sum;
        vmData.roi = dmData.roi_coef;
        vmData.profitability = dmData.profitability;
        vmData.reserveReturn = dmData.reserve_return === undefined ?  100 : dmData.reserve_return;
        vmData.goalId = dmData.goal_id ||
            (dmData.mediaType === 'performance' ? '' : (rmpGoalsEnabled ? u.strategy.MOBILE_CPA_GOAL_ID : defaultGoalId));
        vmData.initGoalId = vmData.goalId;
        vmData.isNewCamp = dmData.isNewCamp;
        vmData.currency = dmData.currency;
        vmData.minGoalsOnCampaign = dmData.minGoalsOnCampaign;
        vmData.metrikaRequestRunning = (this.ctx.metrikaCounter || rmpGoalsEnabled) ? !failedToFetchMetrika : false;

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_roi'),

    elem('attribution-model-control').replace()(function() {
        return {
            block: 'b-strategy2-settings',
            elem: 'row',
            mix: {
                block: 'b-strategy2-settings',
                elem: 'model-field',
                js: {
                    name: 'disabledMetrika',
                    type: 'mod',
                    block: 'b-strategy2-settings',
                    elem: 'row',
                    modName: 'disabled'
                }
            },
            content: applyNext()
        };
    }),

    elem('control')(

        mix()({
            block: 'b-strategy2-settings',
            elem: 'model-field',
            js: {
                name: 'disabledMetrika',
                type: 'mod',
                block: 'b-strategy2-settings',
                elem: 'control',
                modName: 'disabled'
            }
        }),

        content()(function() {
            var modelData = this.modelData;

            if (modelData.metrikaRequestRunning) {
                return {
                    block: 'spin',
                    js: true,
                    mods: {
                        progress: 'yes',
                        theme: 'gray-16'
                    }
                };
            }

            return {
                elem: 'control-roi',
                modelData: modelData
            };
        })
    )
);
