/**
 * Панель настроек стратегии "Средняя рентабельность инвестиций"
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'roi' }, {

    onSetMod: {
        js: function () {
            this.__base.apply(this, arguments);

            var metrika = this.model.get('metrika'),
                cid = this.model.get('cid'),
                currentGoals,
                goals = metrika.campaign_goals,
                rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(this.model.get('mediaType')),
                requests,
                goalId,
                disabled,
                failedToFetchMetrika = u.consts('failedToFetchMetrika');

            // кэшируем плейсхолдер контрола
            this.elem('control');

            this._subscriptionManager.on(this.model, 'metrikaRequestRunning', 'change', function (data) {
                if (!data.value) {
                    this._initControl();
                }
            }, this);

            if (failedToFetchMetrika) {

                this.delMod(this.elem('control'), 'disabled');
                this.setMod(this.elem('row'), 'visible', 'yes');

            } else if (this.model.get('metrikaRequestRunning')) {
                if (!this.model.get('metrikaCounter') && !rmpGoalsEnabled) {

                    this.model.set('metrikaRequestRunning', false);
                    this.setMod(this.elem('control'), 'disabled', this.model.get('metrikaWarning').code === 'no-metrika-optional-visits' ? 'yes' : '');

                } else {
                    this.setMod(this.elem('row'), 'disabled', 'yes');

                    requests = this.model.get('metrikaCounter').split(', ').map(function(metrikaCounter) {
                        return this._requestMetrikaCounterForGoals(metrikaCounter, cid);
                    }.bind(this));

                    $.when.apply($, requests)
                      .then(function() {
                          currentGoals = metrika.campaign_goals.map(function(goal) {
                              return goal.goal_id.toString();
                          });

                          u._.each(arguments, function(availableGoals) {
                              availableGoals.forEach(function(goal) {
                                  goalId = goal.id.toString();
                                  if (currentGoals.indexOf(goalId) === -1) {
                                      goal = {
                                          goal_name: goal.name,
                                          goal_id: goalId,
                                          counter_status: 'Active',
                                          goal_status: 'Active'
                                      };
                                      metrika.campaign_goals.push(goal);
                                  }
                              });
                          });

                          this.model.set('metrika', metrika);
                          // для смарт-кампаний здесь пустая модель
                          if(this.campaignModel) {
                              this.campaignModel.set('metrika', metrika);
                          }
                          this.model.set('metrikaRequestRunning', false);
                          disabled = !rmpGoalsEnabled && this.model.get('metrikaWarning').code === 'no-metrika-optional-visits';
                          this.setMod(this.elem('control'), 'disabled', disabled ? 'yes' : '');
                          this.setMod(this.elem('row'), 'visible', disabled ? 'no' : 'yes');
                      }.bind(this))
                      .fail(function() {
                          this.model.set('metrikaRequestRunning', false);
                          if (rmpGoalsEnabled) {
                              this.setMod(this.elem('control'), 'disabled', '');
                          } else {
                              disabled = this.model.get('metrikaWarning').code === 'no-metrika-optional-visits';
                              this.setMod(this.elem('control'), 'disabled', disabled ? 'yes' : '');
                              this.setMod(this.elem('row'), 'visible', disabled ? 'no' : 'yes');
                          }
                      }.bind(this));
                }

            }
        },

        /**
         * Пересчитываем метрику при смене платформы
         * @param {String} modName = 'platform'
         * @param {String} modValue - тип платформы
         */
        platform: function(modName, modValue) {
            if (this.model.get('mediaType') != 'performance') {
                // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
                // настоящее изменение платформы зафиксируется в модели chooser-а
                this.model.set('where', modValue == u.strategy.NET ? 'context' : 'search').fix();
                this._updateMetrika(
                    'roi',
                    u.getMetrikaWarning(
                        this.model.get('metrika'),
                        this.model.get('goalId'),
                        this.model.get('where'),
                        undefined,
                        u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                        this.model.get('metrikaCounter')
                    )
                );
            }
        },

        /**
         * Пересчитываем метрику при смене платформы
         */
        show: function() {
            // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
            // настоящее изменение платформы зафиксируется в модели chooser-а
            this.model.set('where', this.getMod('platform') == u.strategy.NET ? 'context' : 'search').fix();
            this._updateMetrika(
                'roi',
                u.getMetrikaWarning(
                    this.model.get('metrika'),
                    this.model.get('goalId'),
                    this.model.get('where'),
                    undefined,
                    u['b-strategy2-settings'].getMinGoalsOnCampaign(),
                    this.model.get('metrikaCounter')
                )
            );
        }
    },

    /**
     * Сортировка ошибок валидации
     * @param {String} errorField1 – поле-источник ошибки 1
     * @param {String} errorField2 – поле-источник ошибки 2
     * @override
     * @returns {number}
     */
    sortErrors: function(errorField1, errorField2) {
        var fields = [
            'roi',
            'profitability',
            'weekBid',
            'maxClickBid'
        ];

        return fields.indexOf(errorField1) - fields.indexOf(errorField2);
    },

    /**
     * Инициализирует содержимое блока
     * @private
     */
    _initControl: function(inactive) {
        BEM.DOM.update(this.elem('control'), BEMHTML.apply({
            block: 'b-strategy2-settings',
            elem: 'control-roi',
            modelData: this.model.toJSON()
        }));
        this._updateMetrikaWarning(this.model.get('metrikaWarning'));

        if (inactive) {
            return;
        }

        [
            this.findElem('roi-input'),
            this.findElem('reserve-return'),
            this.findElem('goal-select-control'),
            this.findElem('max-click-bid-toggle'),
            this.findElem('all-key-goals-unavailable-warning'),
            this.findElem('profitability-enabled'),
            this.findElem('profitability'),
            this.findElem('week-bid-control-toggle'),
            this.findElem('not-optimal-goal-notification'),
            this.findElem('input-control', 'field', 'maxClickBid'),
            this.findElem('input-control', 'field', 'weekBid')
        ].forEach(function(elem) {
            elem && elem.length && this.initFieldBlock(elem);
        }.bind(this));

        this.initToggleRow();

        this._subscriptionManager.on(this.model, 'roi', 'change', function() {
            BEM.DOM.replace(this.findElem('roi-value-hint'), BEMHTML.apply({
                block: 'b-strategy2-settings',
                elem: 'roi-value-hint',
                roi: this.model.get('roi'),
                currency: this.model.get('currency')
            }));
        }, this);

        this.findBlockOn('roi-input','input')
    }
});
