/**
 * Модель стратегии "Средняя рентабельность инвестиций"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_roi', baseModel: 'b-strategy2-settings' }, {

    // уточнение максимальной цены клика
    maxClickBidEnabled: 'boolean',

    // уточнение недельного бюджета
    weekBidEnabled: 'boolean',

    // уточнение себестоимости
    profitabilityEnabled: 'boolean',

    // недельный бюджет
    weekBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('weekBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET');
                    },
                    text: iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет')
                },
                lowerClickPrice: {
                    text: iget2('b-strategy2-settings', 'nedelnyy-byudzhet-dolzhen-byt', 'Недельный бюджет должен быть больше максимальной цены клика.'),
                    validate: function(val) {
                        return val > this.get('maxClickBid');
                    },
                    needToValidate: function(val) {
                        return !!val && this.get('maxClickBidEnabled');
                    }
                }
            }
        }
    },

    validationConstants: {
        type: 'object',
        calculate: function () {
            if (this.get('mediaType') === 'performance') {
                return {
                    minMaxClickPrice: {
                        value: u.currencies.getConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE'),
                        formatted: u.currencies.formatConst(this.get('currency'), 'MIN_CPC_CPA_PERFORMANCE')
                    },
                    maxMaxClickPrice: {
                        value: u.currencies.getConst(this.get('currency'), 'MAX_PRICE'),
                        formatted: u.currencies.formatConst(this.get('currency'), 'MAX_PRICE')
                    }
                };
            }

            return {
                minMaxClickPrice: {
                    value: u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID'),
                    formatted: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                },
                maxMaxClickPrice: {
                    value: u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID'),
                    formatted: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                }
            };
        }
    },

    // максимальная цена клика
    maxClickBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return this.get('validationConstants').minMaxClickPrice.value;
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: this.get('validationConstants').minMaxClickPrice.formatted
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return this.get('validationConstants').maxMaxClickPrice.value;
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna-103',
                            'Максимальная цена клика должна быть меньше или равна {foo}',
                            {
                                foo: this.get('validationConstants').maxMaxClickPrice.formatted
                            }
                        );
                    }
                }
            }
        }
    },

    // себестоимость товара от дохода
    profitability: {
        type: 'blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('profitabilityEnabled');
            },
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazana-sebestoimost-tovara', 'Не указана себестоимость товара или услуги') },
                lte: {
                    value: 0,
                    text: iget2(
                        'b-strategy2-settings',
                        'procent-sebestoimosti-dolzhen-byt',
                        'Процент себестоимости должен быть указан в пределах от 0 до 100'
                    )
                },
                gte: {
                    value: 100,
                    text: iget2(
                        'b-strategy2-settings',
                        'procent-sebestoimosti-dolzhen-byt',
                        'Процент себестоимости должен быть указан в пределах от 0 до 100'
                    )
                }
            }
        }
    },

    // коэффициент рентабельности
    roi: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazano-znachenie-rentabelnosti', 'Не указано значение рентабельности инвестиций') },
                min: {
                    value: -1,
                    text: iget2('b-strategy2-settings', 'rentabelnost-investiciy-dolzhna-byt', 'Рентабельность инвестиций должна быть больше -1')
                }
            }
        }
    },

    // возвращать в рекламу
    reserveReturn: {
        type: 'number'
    },

    // идентификатор цели в Метрике
    goalId: {
        type: 'string',
        validation: {
            needToValidate: function() {
                return !this.get('disabledMetrika');
            },
            rules: {
                required: {
                    needToValidate: function() {
                        return this.get('mediaType') === 'performance';
                    },
                    text: iget2('b-strategy2-settings', 'neobhodimo-vybrat-cel', 'Необходимо выбрать цель')
                },
                goalSelected: {
                    needToValidate: function() {
                        return this.get('isNewCamp') || this.get('initGoalId') !== '0';
                    },
                    validate: function() {
                        return this.get('goalId') !== '0';
                    },
                    text: iget2('b-strategy2-settings', 'neobhodimo-vybrat-cel', 'Необходимо выбрать цель')
                }
            },
        }
    },

    // начальное значение идентификатора цели (значение не изменяется)
    initGoalId: 'string',

    // Является ли кампания новой
    isNewCamp: 'boolean',

    // предупреждение о неоптимальной выбранной оптимизации "по всем целям"
    showNotOptimalGoalNotification: {
        dependsFrom: ['goalId'],
        calculate: function() {
            return this.get('goalId') === '0';
        }
    },

    hasNonDefaultGoals: {
        calculate: function() {
            return this.get('meaningfulGoals').some(function (goal) {
                return goal.goal_id !== u.consts('keyGoalsEngagedSessions');
            })
        }
    },

    showAllKeyGoalsUnavailableWarning: {
        dependsFrom: ['goalId'],
        calculate: function() {
            return this.get('goalId') === u.consts('allKeyGoals') && !this.get('hasNonDefaultGoals');
        }
    },

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return this.get('mediaType') == 'performance' ?
                u['b-strategy2-settings'].getHelpLinkUrl('smart-banners-average-roi') || '' :
                u['b-strategy2-settings'].getHelpLinkUrl('average-roi') || '';
        }
    },

    // предупреждение Метрики
    metrikaWarning: {
        type: 'object',
        dependsFrom: ['goalId', 'where', 'metrikaRequestRunning', 'metrika', 'metrikaCounter'],
        calculate: function() {
            return u['b-strategy2-settings'].getMetrikaWarningsText(this.get('name'), this.get('metrika'), this.get('goalId'), this.get('where'), this.get('metrikaCounter'));
        },
        validation: {
            validate: function() {
                return u.strategy.isRmpGoalsAvailable(this.get('mediaType')) || !this.get('disabledMetrika');
            },
            text: {
                value: iget2(
                    'b-strategy2-settings',
                    'pered-nastrojkoj-strategii-ukazhite-schetchik-metriki',
                    'Перед настройкой стратегии укажите счетчик Метрики и задайте ключевые цели кампании'
                ),
                only: true
            }
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            return {
                roi_coef: this.get('roi'),
                profitability: this.get('profitabilityEnabled') ? this.get('profitability') : null,
                reserve_return: this.get('reserveReturn'),
                bid: this.get('maxClickBidEnabled') ? this.get('maxClickBid') : null,
                sum: this.get('weekBidEnabled') ? this.get('weekBid') : null,
                goal_id: this.get('goalId')
            };
        }
    },

    // признак того, что выполняется ajax запрос за метрикой
    metrikaRequestRunning: 'boolean'
});
