/**
 * Шаблон для стратегии "Ручное управление ставками" для ГО на поиске
 * {Object} ctx.modelData – данные модели
 * Описание данных см. в b-strategy2-choose: __getSettingData
 */
block('b-strategy2-settings').mod('name', 'search-maximum-coverage')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {},
            innerName = dmData.innerName,
            options = dmData.options;

        u._.assign(vmData, dmData);

        return applyNext({
            modelData: vmData,
            walletInfo: this.ctx.walletInfo || {}
        });
    }),

    mode('model')('b-strategy2-settings_name_search-maximum-coverage'),

    elem('control').content()(function() {
        var dbSettings = this.modelData.dayBudgetSettings;
        return [
            {
                elem: 'day-budget-settings',
                elemMods: {
                    visible: 'yes',
                    bordered: 'top'
                },
                content: [
                    {
                        block: 'b-day-budget2-settings',
                        mix: { block: 'b-strategy2-settings', elem: 'day-budget' },
                        currency: dbSettings.currency,
                        maxDailyChangeCount: dbSettings.maxDailyChangeCount,
                        timesChangedToday: dbSettings.timesChangedToday,
                        isSet: dbSettings.isSet,
                        showMode: dbSettings.showMode,
                        sum: dbSettings.sum,
                        needHelpLink: dbSettings.needHelpLink,
                        walletInfo: this.walletInfo
                    }
                ]
            }
        ]
    })
);
