/**
 * Панель настроек стратегии "Ручное управление ставками" для ГО на поиске
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'search-maximum-coverage' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // это не dataModel, а просто хэш параметров!
            this._modelData = this.params.modelData;

            this._dayBudget = this.findBlockInside('b-day-budget2-settings');
        }
    },

    /**
     * пробрасывает события дневного бюджета для его кеширования в блоке дневного бюджета
     */
    setDayBudgetEvent: function(event) {
        this._dayBudget.setOnMaximumClicksExceededEvent(event);
    },

    /**
     * Определяет доступность дневного бюджета
     * @returns {Boolean}
     */
    isDayBudgetEnabled: function() {
        return this._modelData.dayBudgetSettings.isEnabled;
    },

    /**
     * Валидирует форму, возвращает результат валидации и отображает ошибки
     * @returns {Boolean}
     * @override;
     */
    validate: function() {
        return this.findBlocksInside(this.domElem.children(), 'b-strategy2-settings').reduce(function(accum, block) {
            return accum && block.validate();
        }, true);
    },

    /**
     * Очищает сообщения об ошибка валидации
     * @override;
     */
    clearErrorMessages: function() {
        this.findBlocksInside(this.domElem.children(), 'b-strategy2-settings').forEach(function(block) {
            block.clearErrorMessages();
        });
    },

    /**
    * Деструктор
    * @override;
    */
    destruct: function() {
        return this.__base.apply(this, arguments);
    }
});
