/**
 * Блок настроек стратегии Недельный бюджет
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.goal_id – id цели Метрики
 * {String} ctx.modelData.sum – недельная ставка
 * {String} ctx.modelData.bid – максимальная цена клика
 */
block('b-strategy2-settings').mod('name', 'week-budget')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {};

        vmData.maxClickBid = dmData.bid || '';
        vmData.weekBid = dmData.sum || '';
        vmData.maxClickBidEnabled = !!dmData.bid;
        vmData.goalId = (dmData.goal_id == u.consts('allKeyGoals') ? null : dmData.goal_id) || '0';
        vmData.mode = dmData.goal_id ? 'cpa' : 'clicks';
        vmData.currency = dmData.currency;
        vmData.mediaType = dmData.mediaType;
        vmData.minGoalsOnCampaign = dmData.minGoalsOnCampaign;
        vmData.metrikaRequestRunning = dmData.mediaType !== 'mobile_content' ? this.ctx.metrikaCounter ? true : false : false;

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_week-budget'),

    elem('control').content()(function() {
        var modelData = this.modelData;

        return [
            {
                elem: 'week-bid-control-2',
                currency: modelData.currency,
                weekBid: modelData.weekBid
            },

            {
                elem: 'max-click-bid-control',
                maxClickBidEnabled: modelData.maxClickBidEnabled,
                maxClickBid: modelData.maxClickBid,
                currency: modelData.currency,
                isReadOnly: modelData.isReadOnly
            },

            {
                elem: 'row',
                mix: [{ block: 'b-strategy2-settings', elem: 'max-click-goal' }],
                content: [
                    {
                        elem: 'radiobox-label',
                        content: iget2('b-strategy2-settings', 'poluchat', 'Получать:')
                    },
                    {
                        elem: 'radiobox-wrap',
                        content: [
                            {
                                block: 'radiobox',
                                mix: [{
                                    block: 'b-strategy2-settings',
                                    elem: 'model-field',
                                    js: {
                                        name: 'mode',
                                        type: 'radiobox'
                                    }
                                }],
                                value: modelData.mode,
                                content: [
                                    {
                                        elem: 'radio',
                                        mix: {
                                            block: 'b-strategy2-settings',
                                            elem: 'radiobox-item'
                                        },
                                        controlAttrs: { value: 'clicks' },
                                        content: iget2('b-strategy2-settings', 'maksimum-klikov', 'максимум кликов')
                                    },
                                    {
                                        elem: 'radio',
                                        mix: [
                                            {
                                                block: 'b-strategy2-settings',
                                                elem: 'model-field',
                                                js: {
                                                    name: modelData.mediaType === 'mobile_content' ? 'cpaDisabled' : 'disabledMetrika',
                                                    type: 'mod',
                                                    block: 'radiobox',
                                                    elem: 'radio',
                                                    modName: 'disabled'
                                                }
                                            },
                                            {
                                                block: 'b-strategy2-settings',
                                                elem: 'week-budget-metrika-radiobox',
                                                elemMods: {
                                                    hidden: modelData.metrikaRequestRunning ? 'yes' : ''
                                                }
                                            }
                                        ],
                                        controlAttrs: { value: 'cpa' },
                                        content: modelData.mediaType === 'mobile_content' ?
                                            iget2('b-strategy2-settings', 'maksimalnoe-kolichestvo-ustanovok', 'максимальное количество установок') :
                                            iget2('b-strategy2-settings', 'maksimalnuyu-konversiyu-po-celi', 'максимальную конверсию по цели:')
                                    },
                                    {
                                        block: 'b-strategy2-settings',
                                        elem: 'control-week-budget',
                                        modelData: modelData
                                    }
                                ]
                            },
                            modelData.mediaType === 'mobile_content' ?
                                {
                                    elem: 'rmp-counters-warning'
                                } :
                                {
                                    elem: 'metrika-warning'
                                }
                        ]
                    }
                ]
            }
        ];
    })
);
