/**
 * Панель настроек стратегии "Недельный бюджет"
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'name', modVal: 'week-budget' }, {

    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            var metrika = this.model.get('metrika'),
                cid = this.model.get('cid'),
                currentGoals,
                requests;

            this.elem('metrika-request-spinner');

            this.model.on('metrikaRequestRunning', 'change', function(data) {
                if (!data.value) {
                    this._initControl();
                }
            }, this);

            if (this.model.get('metrikaRequestRunning')) {
                if (!this.model.get('metrikaCounter')) {

                    this.model.set('metrikaRequestRunning', false);
                    this._updateMetrikaElem();

                } else {

                    requests = this.model.get('metrikaCounter').split(', ').map(function(metrikaCounter) {
                        return this._requestMetrikaCounterForGoals(metrikaCounter, cid);
                    }.bind(this));

                    $.when.apply($, requests)
                        .then(function() {
                            currentGoals = metrika.campaign_goals.map(function (goal) {
                                return goal.goal_id;
                            });

                            u._.each(arguments, function (availableGoals) {
                                availableGoals.forEach(function (goal) {
                                    if (currentGoals.indexOf(goal.id.toString()) === -1) {
                                        metrika.campaign_goals.push({
                                            goal_name: goal.name,
                                            goal_id: goal.id.toString(),
                                            counter_status: 'Active',
                                            goal_status: 'Active'
                                        });
                                    }
                                });
                            });

                            this.model.set('metrika', metrika);
                            this.campaignModel.set('metrika', metrika);
                            this.model.set('metrikaRequestRunning', false);
                            this._updateMetrikaElem();
                        }.bind(this))
                        .fail(function() {
                            this.model.set('metrikaRequestRunning', false);
                            this._updateMetrikaElem();
                        }.bind(this));
                }

            }

        },

        /**
         * Пересчитываем метрику при смене платформы
         * @param {String} modName
         * @param {String} modValue
         */
        platform: function(modName, modValue) {
            // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
            // настоящее изменение платформы зафиксируется в модели chooser-а
            this.model.set('where', modValue == u.strategy.NET ? 'context' : 'search').fix();
            this._updateMetrikaElem();
        },

        /**
         *  Пересчитываем метрику при смене платформы
         */
        show: function() {
            // фиксируем модель, чтобы при инициации платформы isChanged возвращал false
            // настоящее изменение платформы зафиксируется в модели chooser-а
            this.model.set('where', this.getMod('platform') == u.strategy.NET ? 'context' : 'search').fix();
            this._updateMetrikaElem();
        }
    },

    _updateMetrikaElem: function() {
        var metrikaWarning = u.getMetrikaWarning(
            this.model.get('metrika'),
            this.model.get('goalId'),
            this.model.get('where'),
            this.model.get('name'),
            u['b-strategy2-settings'].getMinGoalsOnCampaign(),
            this.model.get('metrikaCounter')
        );

        this._updateMetrika('wb', metrikaWarning);
        this._updateMetrikaWarning(this.model.get('metrikaWarning'));
    },

    /**
     * инициализирует селектор целей метрики внутри блока
     * @private
     */
    _initControl: function() {
        BEM.DOM.replace(this.elem('metrika-request-spinner'), BEMHTML.apply({
            block: 'b-strategy2-settings',
            elem: 'control-week-budget',
            modelData: this.model.toJSON()
        }));

        this.delMod(this.findElem('week-budget-metrika-radiobox'), 'hidden');
        this.initFieldBlock(this.findElem('goal-select-control'));

        this._select = this.findBlockInside('select');
        if (this.model.get('goalSelectDisabled')) {
            this._select.setMod('disabled', 'yes');
        }
        this._radiobox = this.findBlockInside('radiobox');

        this._radiobox.on('change', function() {
            var goalId = (this.model.get('mediaType') === 'mobile_content') ?
                u.strategy.MOBILE_CPA_GOAL_ID :
                this._select.val();

            this.model.set('goalId', this._radiobox.val() === 'cpa' ? goalId : '').fix();
        }, this);

        this.model.trigger('disabledMetrika', 'change', {});
    },

    /**
     * Деструктор
     */
    destruct: function() {
        this._radiobox && this._radiobox.un('change');
        this.__base.apply(this, arguments);
    }
});
