/**
 * Модель стратегии "Недельный бюджет"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_week-budget', baseModel: 'b-strategy2-settings' }, {

    // уточнение максимальной цены клика
    maxClickBidEnabled: 'boolean',

    // id рекламной кампании
    cid: 'number',

    // недельный бюджет
    weekBid: {
        type: 'blank-number',
        precision: 2,
        validation: {
            rules: {
                lte: {
                    value: function() {
                        return u.numberFormatter.round(u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET'));
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'nedelnyy-byudzhet-ne-mozhet', 'Недельный бюджет не может быть меньше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET')
                        });
                    }
                },
                gte: {
                    value: function() {
                        return u.numberFormatter.round(u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET'))
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ukazan-slishkom-bolshoy-nedelnyy', 'Указан слишком большой недельный бюджет');
                    }
                },
                anotherLte: {
                    validate: function(curValue, ruleValue) {
                        return curValue > ruleValue;
                    },
                    needToValidate: function() {
                        return !!this.get('maxClickBid') && !!this.get('weekBid');
                    },
                    value: function() {
                        return this.get('maxClickBid')
                    },
                    text: {
                        required: true,
                        value: iget2(
                            'b-strategy2-settings',
                            'nedelnyy-byudzhet-dolzhen-byt-114',
                            'Недельный бюджет должен быть больше максимальной цены клика'
                        )
                    }
                }
            }
        }
    },

    // url ссылки на описание стратегии
    helpLinkUrl: {
        dependsFrom: ['mediaType'],
        calculate: function() {
            return this.get('mediaType') == 'mobile_content' ?
                u['b-strategy2-settings'].getHelpLinkUrl('weekly-budget-cpi') || '' :
                u['b-strategy2-settings'].getHelpLinkUrl('weekly-budget') || '';
        }
    },

    // максимальная цена клика
    maxClickBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('maxClickBidEnabled');
            },
            rules: {
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2(
                            'b-strategy2-settings',
                            'maksimalnaya-cena-klika-dolzhna',
                            'Максимальная цена клика должна быть больше или равна {foo}',
                            {
                                foo: u.currencies.formatConst(this.get('currency'), 'MIN_AUTOBUDGET_BID')
                            }
                        );
                    }
                },
                gte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ukazana-stavka-bolshe-s', 'Указана ставка больше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    }
                }
            }
        }
    },

    // можно ли выбрать цель Метрики
    goalSelectDisabled: {
        type: 'boolean',
        dependsFrom: ['mode', 'disabledMetrika'],
        calculate: function() {
            return u.consts('failedToFetchMetrika') || this.get('disabledMetrika') || this.get('mode') !== 'cpa' ? 'yes' : '';
        }
    },

    // Режим (максимум кликов/конверсии)
    mode: {
        type: 'enum',
        enum: ['clicks', 'cpa']
    },

    // предупреждение Метрики
    metrikaWarning: {
        type: 'object',
        dependsFrom: ['goalId', 'where', 'metrikaRequestRunning', 'metrika', 'metrikaCounter'],
        calculate: function() {
            return u['b-strategy2-settings'].getMetrikaWarningsText(this.get('name'), this.get('metrika'), this.get('goalId'), this.get('where'), this.get('metrikaCounter'));
        }
    },

    // предупреждение Счетчика РМП
    rmpCountersWarning: {
       type: 'string',

       calculate: function() {
           var warning = iget2(
               'b-strategy2-settings',
               'dlya-pereklyucheniya-na-poluchenie-115',
               'Для переключения на получение максимального количества установок недостаточно данных.'
           );

           return this.get('rmpCounters').allow_autobudget_avg_cpi ? '' : warning;
       }
   },

    // идентификатор цели в Метрике
    goalId: 'string',

    cpaDisabled: {
        type: 'boolean',
        dependsFrom: ['mediaType'],
        calculate: function() {
            return this.get('mediaType') === 'mobile_content' ? !this.get('rmpCounters').allow_autobudget_avg_cpi : this.get('disabledMetrika');
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        dependsFrom: ['maxClickBidEnabled', 'maxClickBid', 'weekBid', 'mode', 'goalId', 'mediaType'],
        calculate: function() {
            return {
                bid: this.get('maxClickBidEnabled') ? this.get('maxClickBid') : '',
                sum: this.get('weekBid'),
                goal_id: this.get('mode') === 'cpa' ? this.get('mediaType') === 'mobile_content' ? u.strategy.MOBILE_CPA_GOAL_ID : this.get('goalId') : ''
            };
        }
    },

    // признак того, что выполняется ajax запрос за метрикой
    metrikaRequestRunning: 'boolean'
});
