/**
 * Блок настроек стратегии Недельный пакет кликов
 * {Object} ctx.modelData – данные модели
 * {String} ctx.modelData.limit_clicks – кол-во кликов
 * {String} ctx.modelData.avg_bid – средняя цена клика
 * {String} ctx.modelData.bid – максимальная цена клика
 */
block('b-strategy2-settings').mod('name', 'week-bundle')(

    def()(function() {
        var dmData = this.ctx.modelData || {},
            vmData = {};

        vmData.clicksLimit = dmData.limit_clicks || '';
        vmData.clickBidEnabled = !!(dmData.avg_bid || dmData.bid);
        vmData.clickBidType = dmData.avg_bid ? 'avg' : 'max';
        vmData.clickBid = dmData.avg_bid || dmData.bid || '';
        vmData.currency = dmData.currency;

        return applyNext({ modelData: vmData });
    }),

    mode('model')('b-strategy2-settings_name_week-bundle'),

    elem('control').content()(function() {
        var modelData = this.modelData;

        return [
            {
                elem: 'week-bundle-control',
                clicksLimit: modelData.clicksLimit,
                currency: modelData.currency
            },
            {
                elem: 'week-bundle-click-bid',
                clickBidEnabled: modelData.clickBidEnabled,
                clickBidType: modelData.clickBidType,
                clickBid: modelData.clickBid,
                currency: modelData.currency,
            }
        ];
    })
);
