/**
 * Модель стратегии "Недельный пакет кликов"
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings_name_week-bundle', baseModel: 'b-strategy2-settings' }, {

    // уточнение цены клика
    clickBidEnabled: 'boolean',

    // цена клика
    clickBid: {
        type: 'optional-blank-number',
        precision: 2,
        validation: {
            needToValidate: function() {
                return this.get('clickBidEnabled');
            },
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazana-cena-klika', 'Не указана цена клика') },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_BID');
                    },
                    text: iget2('b-strategy2-settings', 'ukazana-stavka-menshe-minimalnoy', 'Указана ставка меньше минимальной цены клика')
                },
                maxBid: {
                    validate: function() {
                        return this.get('clickBid') <= u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_BID');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'ukazana-stavka-bolshe-s', 'Указана ставка больше {foo}', {
                            foo: u.currencies.formatConst(this.get('currency'), 'MAX_AUTOBUDGET_BID')
                        });
                    }
                }
            }
        }
    },

    // тип уточнения цены клика
    clickBidType: {
        type: 'enum',
        enum: ['max', 'avg']
    },

    // количество кликов в неделю
    clicksLimit: {
        type: 'blank-number',
        precision: 0,
        validation: {
            rules: {
                required: { text: iget2('b-strategy2-settings', 'ne-ukazano-kolichestvo-klikov', 'Не указано количество кликов на неделю') },
                lte: {
                    value: function() {
                        return u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_CLICKS_BUNDLE');
                    },
                    text: function() {
                        return iget2('b-strategy2-settings', 'kolichestvo-klikov-na-nedelyu', 'Количество кликов на неделю должно быть не менее {foo}', {
                            foo: u.currencies.getConst(this.get('currency'), 'MIN_AUTOBUDGET_CLICKS_BUNDLE')
                        });
                    }
                },
                maxClicks: {
                    validate: function() {
                        return this.get('clicksLimit') <= u.currencies.getConst(this.get('currency'), 'MAX_AUTOBUDGET_CLICKS_BUNDLE');
                    },
                    text: iget2('b-strategy2-settings', 'ukazano-slishkom-bolshoe-kolichestvo', 'Указано слишком большое количество кликов')
                }
            }
        }
    },

    // url ссылки на описание стратегии
    helpLinkUrl: {
        calculate: function() {
            return u['b-strategy2-settings'].getHelpLinkUrl('weekly-package');
        }
    },

    // настройки стратегии
    options: {
        type: 'object',
        calculate: function() {
            var clickBidEnabled = this.get('clickBidEnabled'),
                clickBidType = this.get('clickBidType'),
                clickBid = this.get('clickBid');

            return {
                limit_clicks: this.get('clicksLimit'),
                bid: clickBidEnabled && clickBidType === 'max' ? clickBid : '',
                avg_bid: clickBidEnabled && clickBidType === 'avg' ? clickBid : ''
            };
        }
    }
});
