/**
 * Модификатор для автостратегий
 */
BEM.DOM.decl({ name: 'b-strategy2-settings', modName: 'type', modVal: 'cpm-auto' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            // инициализация автостратегий
            this._cid = this.model.get('cid');
            this._defaultCpmPrice = u.currencies.getConst(this.model.get('currency'), 'DEFAULT_CPM_PRICE');
            this._periodRadiobox = this.findBlockInside(this.findElem('row', 'type', 'spend-radiobox'), 'radiobox');

            // Если это реклама на морде, нужно уточнить выбранную версию
            if (this.model.get('mediaType') === 'cpm_yndx_frontpage') {
                this._defaultCpmPrice = Math.max(
                    u.currencies.getConst(this.model.get('currency'), 'DEFAULT_CPM_PRICE'),
                    this.model.get('minAutobudgetAvgCpm')
                );
            } else if (this.model.get('isAvgCpv')) {
                this._defaultCpmPrice = Math.max(u.currencies.getConst(this.model.get('currency'), 'DEFAULT_AVG_CPV'));
            }

            // флаг: средняя цена вычислена(рекомендованная или дефолтная), а не установлена пользователем
            this._isReceivedPrice = {
                period: true,
                week: true
            };

            this._initPeriodStrategy()
                ._initRecommendationStrategy();

            // строим прогноз всегда для недельного периода
            if (!this._isPeriod()) {
                this._createForecast();
            }

            this._subscriptionManager.wrap(this.model)
                .on('spendMode', 'change', function(e, data) {
                    this.setMod(this.elem('coverage-control'), 'spend-mode', data.value);
                }, this);
        }
    },

    /**
     * Подписка на события стратегий с периодом
     * @returns {BEM}
     * @private
     */
    _initPeriodStrategy: function() {
        this._recreatePeriod = this.findBlockOn('recreate-period', 'button2');
        this._changePeriod = this.findBlockOn('change-period', 'button2');
        this._coverageControlsInputPeriod = this.findBlocksInside(
            this.elem('coverage-control-input', 'type', 'period'),
            'input'
        );
        this._fakeAutoProlongationCheckbox = this.findBlockOn(this.elem('auto-prolongation', 'type', 'preview-edit'), 'checkbox');

        BEM.DOM.replace(
            this.findElem('period'),
            BEMHTML.apply({
                block: 'b-strategy2-settings',
                elem: 'period',
                period_range: this.model.get('period_range')
            })
        );

        this._subscriptionManager.on(this._recreatePeriod, 'click', function() {
            var defaultCalendar = this.model.get('defaultCalendarSettings');

            this.model.set(
                'period',
                {
                    start: defaultCalendar.start,
                    finish: defaultCalendar.finish
                },
                { ignoreInputValidation: true }
            );

            this.model.set('budget', '');
            this.model.set('clickBidPeriod', this._defaultCpmPrice, { isReceivedPrice: true });
            this.model.set('isSavedPeriodStrategy', false);
            this.model.set('periodStrategyEditMode', 'recreate');

            this._fakeAutoProlongationCheckbox.setMod('checked', this.model.get('autoProlongation') ? 'yes' : '');
            this.model.set('autoProlongation', true);
            this.setMod(this.elem('coverage-control'), 'period-in', 'edit');
        }, this);

        this._changePeriod && this._subscriptionManager.on(this._changePeriod, 'click', function() {
            this.model.set('isSavedPeriodStrategy', false);
            this.model.set('periodStrategyEditMode', 'change');

            this._fakeAutoProlongationCheckbox.setMod('checked', this.model.get('autoProlongation') ? 'yes' : '');
            this.setMod(this.elem('coverage-control'), 'period-in', 'edit');
        }, this);

        this._subscriptionManager.wrap(this.model)
            .on('period_range', 'change', function(e, data) {
                if (!data.ignoreInputValidation) {
                    // DIRECT-75526 обновляем тултипы бюджета на период
                    this._coverageControlsInputPeriod.forEach(this._validateField, this);
                }

                BEM.DOM.replace(
                    this.findElem('period'),
                    BEMHTML.apply({
                        block: 'b-strategy2-settings',
                        elem: 'period',
                        period_range: data.value
                    })
                );

                this._createForecast();
            }, this)
            .on('periodStrategyEditMode', 'change', function(e, data) {
                var currentValue = this.model.get('periodStrategyEditMode'),
                    defaultCalendarSettings = this.model.get('defaultCalendarSettings'),
                    finishDate,
                    minFinishDate,
                    calendarSettings = Object.assign({}, defaultCalendarSettings),
                    periodValue = this.params.modelData.period,
                    today = u.moment(u.moment(), 'YYYY-MM-DD'),
                    finishPeriodDate = u.moment(periodValue.finish, 'YYYY-MM-DD');

                if (currentValue === 'change') {
                    // минимальная дата в случае редактирования сегодня + 1,
                    // но b-date-input работает с особенностями и именно для сегодня,
                    // нужно указывать на 1 день меньше для правильного дизэйбла в календаре
                    minFinishDate = today;
                    finishDate = minFinishDate.isAfter(finishPeriodDate) ?
                        minFinishDate.format('YYYY-MM-DD') :
                        periodValue.finish;

                    calendarSettings = Object.assign({}, defaultCalendarSettings, {
                        start: periodValue.start,
                        finish: finishDate
                    });

                    this.model.set('period', {
                        start: periodValue.start,
                        finish: finishDate
                    });
                }

                BEM.DOM.update(this.elem('coverage-control-period-selector'), BEMHTML.apply({
                    block: 'b-strategy2-settings',
                    elem: 'coverage-control-period-selector',
                    controlMode: currentValue,
                    calendar: calendarSettings,
                    period_range: this.model.get('period-range')
                }));

                if (currentValue === 'change') {
                    this._initFinishDatePicker(
                        minFinishDate.toDate(),
                        u.moment(periodValue.start).add(u['b-strategy2-settings'].MAX_STRATEGY_PERIOD - 1, 'days').toDate()
                    );
                } else if (currentValue === 'recreate') {
                    this._initCalendar && this._initCalendar();
                }

                BEM.DOM.update(this.elem('coverage-control-info'), BEMHTML.apply({
                    block: 'b-strategy2-settings',
                    elem: 'coverage-control-info',
                    controlMode: currentValue
                }));

                this.setMod(
                    this.elem('row', 'type', 'change-period-controls'),
                    'hidden',
                    'yes'
                );

                this._periodRadiobox.setMod('disabled', currentValue === 'change' ? 'yes' : '');
            }, this);

        this._checkCampaignPeriod();

        return this;
    },

    _initFinishDatePicker: function(minDate, maxDate) {
        var finishDatePicker = this.findBlockOn('finish-period', 'b-date-input');

        if (!finishDatePicker) {
            return;
        }

        finishDatePicker.setLimits(minDate, maxDate);

        if (finishDatePicker) {
            finishDatePicker.on('change', this._onFinishDateChange, this);
        }
    },

    _onFinishDateChange: function(e, val) {
        this.model.set('period', {
            start: this.model.get('period').start,
            finish: val
        });
    },

    /**
     * Подписка на события рекомендаций для стратегий
     * @private
     */
    _initRecommendationStrategy: function() {
        this._subscriptionManager.wrap(this.model)
            .on('clickBid clickBidPeriod', 'change', function(e, data) {
                this._isReceivedPrice[this.model.get('spendMode')] = !!data.isReceivedPrice;
                this._cid && this._toggleModRecommendationPrice();
                this._getSlider().val(data.value);
            }, this)
            .on('coverageWeekMode coveragePeriodMode', 'change', function() {
                this._createForecast();
            }, this);

        this.findBlocksInside(this.findElem('slider'), 'slider').forEach(function(slider) {
            this._subscriptionManager.wrap(slider)
                .on('change', function() {
                    var clickBid = this._isPeriod() ? 'clickBidPeriod' : 'clickBid';
                    this.model.set(clickBid, this._getSlider().val());
                }, this);
        }, this);
    },

    // Контролы элемента recommendation-price
    _recommendationControls: null,

    /**
     * Поиск и кеширование контролов элемента recommendation-price
     * @param {String} elem
     * @private
     */
    _getRecommendationControls: function(elem) {
        var spendMode = this.model.get('spendMode'),
            recommendationElem = this.findElem('recommendation-price', 'type', spendMode);

        this._recommendationControls || (this._recommendationControls = {});

        this._recommendationControls[spendMode] || (this._recommendationControls[spendMode] = {});

        this._recommendationControls[spendMode][elem] ||
        (this._recommendationControls[spendMode][elem] = this.findBlockInside(recommendationElem, elem));

        return this._recommendationControls[spendMode][elem];
    },

    /**
     * Получение прогноза
     * @private
     */
    _createForecast: function() {
        if (!this.model.validate('campaignPeriod').valid || this.model.get('isSavedPeriodStrategy') ) return;

        var isPeriod = this._isPeriod(),
            budget = isPeriod ? 'budget' : 'weekBid',
            clickBid = isPeriod ? 'clickBidPeriod' : 'clickBid',
            recommendationPrice = isPeriod ? 'recommendationPricePeriod': 'recommendationPriceWeek',
            isValid = this.model.validate(budget).valid,
            getData =  isValid ? this._getCampaignForecast() : Promise.resolve({});

        getData.then(function(data) {
            this._buildCpmSliders(data.gradientColors); // построение слайдера

            if (this._cid) {
                this.model.set(recommendationPrice, data.recommendationPrice); // обновление поле модели рекоменд.цены
                this._replaceRecommendationPrice(); // обновление рекомендованную цену
                this._toggleModRecommendationPrice() // отображение блока рекомендация цены
            } else {
                var price = data.recommendationPrice || this._defaultCpmPrice;

                // установка средней цены, если она не была установлена пользователем
                this._isReceivedPrice[this.model.get('spendMode')] &&
                this.model.set(clickBid, price, { isReceivedPrice: true });
                // отображение блока рекомендация цены
                this._getRecommendationControls('radiobox').setMod('disabled', isValid ? '' : 'yes');
            }

            this._updateId(data.requestId); // обновление id в тултипе
            this._setForecastDescription(data.errorText, isValid); // вывод информации по прогнозу
        }.bind(this))
    },

    _sliders: null,

    /**
     * Получение  и кеширование слайдера
     * @returns {BEM}
     */
    _getSlider: function() {
        var spendMode = this.model.get('spendMode');

        this._sliders || (this._sliders = {});

        this._sliders[spendMode] ||
        (this._sliders[spendMode] = this.findBlockInside(this.findElem('slider', 'type', spendMode), 'slider'));

        return this._sliders[spendMode];
    },

    /**
     * Возвращает true/false, если стратегия указана за период
     * @returns {Boolean}
     * @private
     */
    _isPeriod: function() {
        return this.model.get('spendMode') === 'period';
    },

    /**
     * Получение параметров для запроса в прогнозатор
     * @returns {Object}
     * @private
     */
    _getParams: function() {
        var isPeriod = this._isPeriod(),
            webApiStrategyName = (function(modelName) {
                switch (modelName) {
                    case 'b-strategy2-settings_name_cpm-max-coverage':
                        return 'MAX_REACH';
                    case 'b-strategy2-settings_name_avg-cpv':
                        return 'AVG_CPV';
                    default:
                        return 'MIN_CPM';
                }
            })(this.model.name),
            multiplier = this.model.get('multipliersPct'), // значения корректировок
            rf = this.model.get('rf'), // количество показов
            rfReset = this.model.get('rfReset'), // количество дней
            endDate = isPeriod ?
                this.model.get('period').finish :
                u.moment().add('days', 6).format('YYYY-MM-DD'), // если за неделю, то к текущему дню прибавляем неделю
            startDate = isPeriod ?
                this.model.get('period').start :
                u.moment().format('YYYY-MM-DD'), // если за неделю, то берем текущий день
            impressionLimit = this.__self.getImpressionLimit(rf, rfReset, startDate, endDate),
            params = {
                strategy: {
                    budget: isPeriod ? this.model.get('budget') : this.model.get('weekBid'),
                    end_date: endDate,
                    start_date: startDate,
                    type: webApiStrategyName,
                    impression_limit: {
                        days: impressionLimit.rfReset,
                        impressions: impressionLimit.rf
                    }
                },
                traffic_type_corrections:  this.__self.getTrafficTypeCorrections(multiplier)
            };

        if (isPeriod) {
            params.strategy.auto_prolongation = this.model.get('autoProlongation') ? 1 : 0;
        }

        if (this._cid) {
            params.campaign_id = Number(this._cid);
        } else {
            var targetMode = isPeriod ? this.model.get('coveragePeriodMode') : this.model.get('coverageWeekMode');
            params.new_campaign_example_type = (targetMode === 'wide') ? 0 : 1;
            // Если это новая кампания без cid'a, нужно уточнить её тип для прогнозатора
            params.campaign_type = this.model.get('mediaType').toUpperCase();
        }

        // Если это реклама на морде, нужно уточнить выбранную версию
        if (this.model.get('mediaType') === 'cpm_yndx_frontpage' && this.model.get('frontpageType')) {
            params.target_tags = this.model.get('frontpageType');
        }

        if (this.model.get('mediaType') === 'cpm_banner' || this.model.get('mediaType') === 'cpm_deals') {
            var eshowsSettings = {};

            if (this.model.get('impressionStandardTime')) {
                params.impression_standard_time = this.model.get('impressionStandardTime');
            }

            if (
                this.model.get('eshowsBannerRate').length ||
                typeof this.model.get('eshowsBannerRate') === 'number'
            ) {
                eshowsSettings.banner_rate = this.model.get('eshowsBannerRate') ? 'on' : 'off';
            }

            if (
                this.model.get('eshowsVideoRate').length ||
                typeof this.model.get('eshowsVideoRate') === 'number'
            ) {
                eshowsSettings.video_rate = this.model.get('eshowsVideoRate') ? 'on' : 'off';
                eshowsSettings.video_type = this.model.get('eshowsVideoType');
            }

            if (Object.keys(eshowsSettings).length) {
                params.eshows_settings = eshowsSettings;
            }
        }

        return params;
    },

    /**
     * Строит cpm-слайдер
     * @param {Array} colors
     * @private
     */
    _buildCpmSliders: function(colors) {
        var clickBid = this._isPeriod() ? 'clickBidPeriod' : 'clickBid',
            currency = this.model.get('currency'),
            gradient = [],
            min,
            max,
            maxCpmPrice;

        if (this.model.get('isAvgCpv')) {
            min = this.model.get('minAutobudgetAvgCpm') || u.currencies.getConst(currency, 'MIN_AVG_CPV');
            maxCpmPrice = u.currencies.getConst(currency, 'MAX_AVG_CPV');
            max = u.currencies.getConst(currency, 'MIDDLE_AVG_CPV');
        } else {
            min = this.model.get('minAutobudgetAvgCpm') ||
                u.currencies.getConst(currency, 'MIN_AUTOBUDGET_AVG_CPM');
            maxCpmPrice = u.currencies.getConst(currency, 'MAX_CPM_PRICE');
            max = this.model.get('minAutobudgetAvgCpm') > u.currencies.getConst(currency, 'MIN_AUTOBUDGET_AVG_CPM') ?
                (maxCpmPrice / 6) :
                (maxCpmPrice / 10);
        }

        if (colors) {
            gradient = u.gradient(
                colors,
                {
                    min: min,
                    max: max, // граница основных значений, под ней будет подсказка сумма + валюта
                    maxCpmPrice: maxCpmPrice,
                    rupture: 70
                }
            )
        }

        this._getSlider()
            .setGradient(gradient)
            .val(this.model.get(clickBid))
            .delMod('loading');

        if (this.model.get('periodStrategyEditMode') !== 'change') {
            this._periodRadiobox.delMod('disabled');
        }
    },

    /**
     * Ручка прогноза в медийных кампаниях
     * @returns {Promise}
     * @private
     */
    _getCampaignForecast: function() {
        this._getSlider().setMod('loading', 'yes');
       this._periodRadiobox.setMod('disabled','yes');

        return BEM.blocks['i-web-api-request'].mediareach.getCampaignForecast(u.consts('ulogin'), this._getParams())
            .then(function(data) {
                var colors = {
                    red: '#ff3333',
                    yellow: '#f3f828',
                    green: '#9bdb5a'
                };

                if (data.result) {
                    return {
                        gradientColors: data.result.gradient.map(function(item) {
                            return {
                                name: colors[item.color],
                                range: [item.min, item.max]
                            };
                        }),
                        recommendationPrice: data.result.recommended_price,
                        errorText: this._getErrorText(data),
                        requestId: data.request_id
                    }
                } else {
                    return {
                        errorText: this._getErrorText(data),
                        requestId: data.request_id
                    };
                }
            }.bind(this))
            .catch(function() {
                return {
                    errorText: iget2('b-strategy2-settings', 'error-text-default', 'Не удалось рассчитать прогноз')
                };
            }.bind(this))
    },

    /**
     * Обновляет Id в тултипе
     * @param {String} requestId
     * @private
     */
    _updateId: function(requestId) {
        this.findBlockOn(this.findElem('forecast-hint', 'type', this.model.get('spendMode')), 'b-hintable-popup')
            .setHintContent(
                BEMHTML.apply({
                    block: 'b-strategy2-settings',
                    elem: 'help-forecast-content',
                    requestId: requestId
                })
            );
    },

    /**
     * Показываем/скрываем описание для прогноза
     * @param {String} errorText
     * @param {Boolean} isValid
     * @private
     */
    _setForecastDescription: function(errorText, isValid) {
        var description,
            spendMode = this.model.get('spendMode');

        if (!isValid)  {
            description = '';
        } else if (errorText) {
            description = errorText;
        } else {
            description = this._cid ? '' :
                iget2('b-strategy2-settings', 'forecast-description-without-target', 'Рекомендация цены для вашей кампании будет уточнена после настройки групп объявлений');
        }

        this.setMod(this.elem('row-forecast-description', 'type', spendMode),'hidden', description ? '' : 'yes');
        description && this.elem('forecast-description', 'type', spendMode).text(description);
    },

    /**
     * Получение текста ошибки для описания прогноза
     * @param {Object} data
     * @returns {String}
     * @private
     */
    _getErrorText: function(data) {
        var error = data.validation_result.errors[0];

        if (error) {
            var errorCode = error.code,
                errorType = errorCode.split('.').pop();

            switch (errorType) {
                case 'LOW_REACH':
                    return iget2('b-strategy2-settings', 'error-text-low-reach', 'Недостаточный охват');
                case 'UNKNOWN_SEGMENTS':
                    return iget2('b-strategy2-settings', 'error-text-unknown-segments', 'Неизвестные сегменты');
                case 'UNSUPPORTED_SEGMENTS':
                    return iget2('b-strategy2-settings', 'error-text-unsupported-segments', 'Неподдерживаемые сегменты');
                case 'NO_SUITABLE_ADGROUPS':
                    return iget2('b-strategy2-settings', 'error-text-no-suitable-adgroups', 'Нет подходящих групп (в нужных статусах, с таргетингом на профиль)');
                case 'CONTAINS_KEYWORD_ADGROUPS':
                    return iget2('b-strategy2-settings', 'error-text-contains-keyword-adgroups', 'Кампания содержит как минимум одну валидную группу на ключевых словах');
                default:
                    return iget2('b-strategy2-settings', 'error-text-default', 'Не удалось рассчитать прогноз');
            }
        }

        return '';
    },

    /**
     * Показываем/скрываем рекомендуемую цену, если отклонение от текущей 5%
     * @private
     */
    _toggleModRecommendationPrice: function() {
        var spendMode = this.model.get('spendMode'),
            isPeriod = this._isPeriod(),
            currentPrice = isPeriod ? this.model.get('clickBidPeriod') : this.model.get('clickBid'),
            recommendationPrice = isPeriod ?
                this.model.get('recommendationPricePeriod') :
                this.model.get('recommendationPriceWeek'),
            isDiffPrice = recommendationPrice ?
                Math.abs(recommendationPrice - currentPrice) > 0.05 * recommendationPrice :
                null,
            price = this.elem('price', 'mode', spendMode),
            notification = this.elem('notification-price', 'mode', spendMode);

        this.setMod(price, 'hidden', isDiffPrice ? '' : 'yes');
        this.setMod(notification, 'hidden', (!recommendationPrice || isDiffPrice) ? 'yes' : '');
        this._getRecommendationControls('button').setMod('hidden', (!recommendationPrice || isDiffPrice) ? '' : 'yes');
        this._getRecommendationControls('button').setMod('disabled', recommendationPrice ? '' : 'yes');
    },

    /**
     * Обновление рекомендуемой цены
     * @private
     */
    _replaceRecommendationPrice: function() {
        var recommendationPrice = this._isPeriod() ?
            this.model.get('recommendationPricePeriod') :
            this.model.get('recommendationPriceWeek');

        if (recommendationPrice) {
            this.elem('price', 'mode', this.model.get('spendMode') )
                .text(recommendationPrice + ' ' + u.formatCurrency(this.model.get('currency')));
        }
    },

    /**
     * Клик по кнопке: устанавливает в среднюю цену рекомендуемую
     * @private
     */
    _onClickCoverageButton: function() {
        var isPeriod = this._isPeriod(),
            clickBid = isPeriod ? 'clickBidPeriod' : 'clickBid',
            recommendationPrice = isPeriod ? 'recommendationPricePeriod' : 'recommendationPriceWeek';

        this.model.set(clickBid, this.model.get(recommendationPrice));
        this._toggleModRecommendationPrice();
    }
}, {
    live: function() {
        this.liveBindTo('coverage-control-button', 'click', function() {
            this._onClickCoverageButton();
        });

        return false;
    },

    /**
     * Получение параметров ограничения запросов для прогноза
     * @param {String} startDate
     * @param {String} endDate
     * @param {Number} rf
     * @param {Number} rfReset
     * @returns {Object}
     */
    getImpressionLimit: function(rf, rfReset, startDate, endDate) {
        // если нет количества показов
        if (!rf) {
            return {
                rf: 0,
                rfReset: 0
            };
        }

        // если количество показов есть, и если количество дней 0, то указываем все время проведения
        if (rfReset === 0) {
            return {
                rf: rf,
                rfReset: u.moment(endDate).diff(u.moment(startDate), 'days') + 1
            };
        }

        // если количество показов есть, и если количества дней нет
        if (!rfReset) {
            return {
                rf: 0,
                rfReset: 0
            };
        }

        //если есть и показы и дни
        return {
            rf: rf,
            rfReset: rfReset
        };
    },

    /**
     * Получение параметров корректировок для прогноза
     * @returns {Object}
     */
    getTrafficTypeCorrections: function(multiplier) {
        if(!multiplier) {
            return {};
        }

        var multiplierTypes = {
            cpm_banner: 'banner',
            inpage: 'video_inpage',
            instream_web: 'video_instream',
            interstitial: 'video_interstitial',
            inbanner: 'video_inbanner',
            rewarded: 'video_rewarded'
        };

        return Object.keys(multiplier).reduce(function(res, key) {
            var trafficType = multiplierTypes[key];
            res[trafficType] = multiplier[key];

            return res;
        }, {});
    }
});
