/**
 * {Object} ctx.modelData – модель стратегии
 * {String} ctx.modelData.currency – валюта
 * {String} ctx.modelData.title – название
 * {Object} ctx.modelData.metrika – метрика (сериализованный dm-metrika)
 * {Object} ctx.modelData.rmpCounters – РМП счетчики (сериализованный dm-rmp-counters)
 * {String} ctx.modelData.where – площадка
 */
block('b-strategy2-settings')(

    def().match(function() {

        return this.modelData;
    })(function() {
        var dmData = this.ctx.modelData || {},
            vmData = this.modelData;

        vmData.currency = dmData.currency || 'YND_FIXED';
        vmData.title = u.strategy.getTitleByName(dmData.name, this.ctx.platform, this.ctx.campaignType, dmData, this.ctx.isChangeManualStrategyName);
        this.ctx.needHints && (vmData.description = u.strategy.getStrategyDescription(dmData));
        vmData.cid = this.ctx.cid;
        vmData.rf = this.ctx.rf;
        vmData.multipliersPct = this.ctx.multipliersPct;
        vmData.rfReset = this.ctx.rfReset;
        vmData.name = dmData.name;
        vmData.metrika = dmData.metrika;
        vmData.rmpCounters = dmData.rmpCounters;
        vmData.where = dmData.where || 'search';
        vmData.mediaType = dmData.mediaType;
        vmData.metrikaCounter = this.ctx.metrikaCounter;
        vmData.strategyCmpAutoCoverage = dmData.strategyCmpAutoCoverage;
        vmData.attributionModel = this.ctx.currentStrategyName === dmData.name ? this.ctx.attributionModel : 'last_yandex_direct_click';
        vmData.meaningfulGoals = dmData.meaningfulGoals;
        vmData.isCpaPayForConversionsStrategyAllowed = dmData.isCpaPayForConversionsStrategyAllowed;
        vmData.isCpaPayForConversionEnabled = dmData.isCpaPayForConversionsStrategyAllowed && dmData.isCpaPayForConversionEnabled;
        vmData.lastStrategyChange = dmData.lastStrategyChange;
        vmData.customBudgetMinValue = this.ctx.customBudgetMinValue;

        return applyNext({
            modelData: vmData,
            needHints: this.ctx.needHints,
            currency: u.currencies.getName(vmData.currency),
            isSavedPeriodStrategyEditable: this.ctx.isSavedPeriodStrategyEditable
        });
    }),

    mode('model')('b-strategy2-settings'),

    mode('warning-messages')({}),

    js()(function() {
        return {
            modelName: apply('model'),
            modelData: this.modelData || this.ctx.modelData,
            needHints: this.ctx.needHints,
            currency: this.currency,
            campaignType: this.ctx.campaignType,
            isChangeManualStrategyName: this.ctx.isChangeManualStrategyName,
            isCpaPayForConversionsStrategyAllowed: this.ctx.isCpaPayForConversionsStrategyAllowed
        };
    }),

    content().match(function() {
        return !this.ctx.content;
    })(function() {
        return [
            { elem: 'title' },
            this.ctx.needHints && { elem: 'description' },
            { elem: 'control' }
        ];
    }),

    content()(function() {
        var campaignType = this.ctx.campaignType;

        return [
            applyNext(),
            u['attribution-model'].isNewPolicyEnabled(campaignType) && {
                elem: 'attribution-model-control',
                modelData: this.modelData,
                currentStrategyName: this.ctx.currentStrategyName
            },
            { elem: 'errors' }
        ];
    }),

    elem('label').tag()('label'),

    elem('title').content()(function() {

        return [
            {
                elem: 'title-text',
                tag: 'span',
                mix: {
                    elem: 'model-field',
                    js: {
                        name: 'title',
                        type: 'inline'
                    }
                },
                content: this.modelData.title
            }
        ];
    }),

    elem('sub-title').tag()('span')
);
