BEM.DOM.decl({ name: 'b-strategy2-settings', baseBlock: 'i-glue' }, {
    onSetMod: {
        js: function() {
            this.__base.apply(this, arguments);

            this._subscriptionManager = BEM.create('i-subscription-manager');

            this.campaignModel = BEM.MODEL.getOne('m-campaign');

            this.initToggleRow();

            this.params.needHints && BEM.DOM.append(this.elem('title'), BEMHTML.apply({
                block: 'b-strategy2-settings',
                elem: 'title-help',
                helpUrl: this.model.get('helpLinkUrl')
            }));

            // Триггерим события на полях связанных с метрикой и счетчиками РМП
            ['disabledMetrika', 'metrikaWarning', 'goalSelectDisabled', 'rmpCountersWarning', 'cpaDisabled'].forEach(function (field) {
                if (typeof this.model.get(field) !== 'undefined') {
                    this.model.trigger(field, 'change', {value: this.model.get(field)});
                }
            }, this);

            // показываем предупреждение (если оно есть) и подписываемся на изменения
            if (this.model.hasField('metrikaWarning')) {
                this._updateMetrikaWarning(this.model.get('metrikaWarning'));
                this.model.on('metrikaWarning', 'change', function (e, data) {
                    this._updateMetrikaWarning(data.value);
                }, this);
            }

            // показываем предупреждение (если оно есть) и подписываемся на изменения
            if (this.model.hasField('rmpCountersWarning')) {
                this._updateRmpCountersWarning(this.model.get('rmpCountersWarning'));
                this.model.on('rmpCountersWarning', 'change', function(e, data) {
                    this._updateRmpCountersWarning(data.value);
                }, this);
            }

            this._subscriptionManager.wrap(BEM.blocks['input'])
                .on(this.elem('prevalidate-input'), 'blur', function(e) {
                    var fieldName = this._validateField.bind(this)(e.block).field;
                    if (fieldName === 'budget' || fieldName === 'weekBid') {
                        this._createForecast();
                    }
                }, this);

            this._subscriptionManager.on(this.model, 'change', this._onModelChange, this);

            this._fetchConversionsByGoalId();
        }
    },

    initToggleRow: function() {
        this.findBlocksOn('toggle-row', 'checkbox').forEach(function(checkbox) {
            checkbox.on('change', function(e) {
                var checkbox = e.block,
                    row = checkbox.domElem.closest(this.buildSelector('row'));

                this.setMod(row, 'collapsed', checkbox.isChecked() ? '' : 'yes');
            }, this);
        }, this);
    },

    onElemSetMod: {
        'goal-select': {
            disabled: function(elem, modName, modVal) {
                this._goalSelect || (this._goalSelect = this.findBlockInside(elem, 'select'));
                this._goalSelect.setMod('disabled', modVal);
            }
        }
    },

    /**
     * Показывает постоянную ошибку о неверном периоде кампании
     * @private
     */
    _checkCampaignPeriod: function() {
        var campaignPeriodValidate = this.model.validate('campaignPeriod');

        if (!campaignPeriodValidate.valid) {
            this._showErrors(campaignPeriodValidate.errors.map(function(error) {
                return error.text;
            }));

            this._hasErrors = true;
        }
    },

    _changeControlVisibility: function(e, data) {
        this._changeControlWithAllGoalsVisibleStatus(data.value);
    },

    _changeControlWithAllGoalsVisibleStatus: function(payForConversionFlag) {
        var cpaPeriod = this.findElem('period-week'),
            cpaAvg = this.findElem('cpa-avg-input-text'),
            goalSelect = this.findElem('goal-select'),
            specialGoalSelect = this.findElem('goal-select-special');

        if (payForConversionFlag) {
            this.setMod(this.findElem('max-click-bid-control'), 'visible', 'no');
            this.setMod(goalSelect, 'visible', 'no');
            this.setMod(specialGoalSelect, 'visible', 'yes');
            this.setMod(cpaPeriod, 'visible', 'no');
            this.setMod(cpaAvg, 'visible', 'no');
            this._updateSpecialGoalsSelect();
        } else {
            this.setMod(this.findElem('max-click-bid-control'), 'visible', 'yes');
            this.setMod(goalSelect, 'visible', 'yes');
            this.setMod(specialGoalSelect, 'visible', 'no');
            this.setMod(cpaPeriod, 'visible', 'yes');
            this.setMod(cpaAvg, 'visible', 'yes');
            this._updateGoalsSelect();
        }
    },

    _updateGoalsSelect: function() {
        var goals = this.model.get('metrika').campaign_goals,
            rmpGoalsEnabled = u.strategy.isRmpGoalsAvailable(this.model.get('mediaType'));

        if (goals.length === 0 && rmpGoalsEnabled) {
            this.model.set('goalId', u.strategy.MOBILE_CPA_GOAL_ID);
        } else {
            this.model.set('goalId', this.findBlockInside(this.elem('goal-select-control'), 'select').val());
        }
    },

    _updateSpecialGoalsSelect: function() {
        var goals = this.model.get('metrika').campaign_goals;

        if (goals.length) {
            var goalId = String(goals[0].goal_id);

            this.model.set('goalId', goalId);
        }
    },

    _listenToPayForConversionFlag: function(needAdditionalListener) {
        var maxClickBid = this.findElem('max-click-bid-control'),
            goalSelectSpecial = this.findElem('goal-select-special'),
            goalSelect = this.findElem('goal-select'),
            isCpaPayForConversionsStrategyAllowed = this.model.get('isCpaPayForConversionsStrategyAllowed'),
            checkbox = this.findBlockOn('checkbox-control', 'checkbox');

        if (isCpaPayForConversionsStrategyAllowed && this.model.get('isCpaPayForConversionEnabled')) {
            this.setMod(maxClickBid, 'visible', 'no');
            this.setMod(goalSelectSpecial, 'visible', 'yes');
            this.setMod(goalSelect, 'visible', 'no');
        } else {
            this.setMod(goalSelectSpecial, 'visible', 'no');
            this.setMod(goalSelect, 'visible', 'yes');
        }

        if (checkbox && needAdditionalListener) {
            checkbox.on('change', function () {
                var checkboxValue = !this.model.get('isCpaPayForConversionEnabled');

                this.model.set('isCpaPayForConversionEnabled', checkboxValue);
            }, this);
        }
    },

    _setInitVisibleMaxBidsCheckbox: function() {
        var maxClickBid = this.findElem('max-click-bid-control'),
            goalSelectSpecial = this.findElem('goal-select-special'),
            goalSelect = this.findElem('goal-select'),
            cpaPeriod = this.findElem('period-week'),
            cpaAvg = this.findElem('cpa-avg-input-text'),
            isCpaPayForConversionsStrategyAllowed = this.model.get('isCpaPayForConversionsStrategyAllowed');

        if (isCpaPayForConversionsStrategyAllowed && this.model.get('isCpaPayForConversionEnabled')) {
            this.setMod(maxClickBid, 'visible', 'no');
            this.setMod(goalSelectSpecial, 'visible', 'yes');
            this.setMod(goalSelect, 'visible', 'no');
            this.setMod(cpaPeriod, 'visible', 'no');
            this.setMod(cpaAvg, 'visible', 'no');
        } else {
            this.setMod(goalSelectSpecial, 'visible', 'no');
            this.setMod(goalSelect, 'visible', 'yes');
            this.setMod(cpaPeriod, 'visible', 'yes');
            this.setMod(cpaAvg, 'visible', 'yes');
        }
    },

    /**
     * Возвращает настройки стратегии
     * @abstract
     * @returns {Object}
     */
    getOptions: function() {
        return this.model.get('options');
    },

    getName: function() {
        return this.model.get('name');
    },

    /**
     * Валидирует форму, возвращает результат валидации и отображает ошибки
     * @returns {Boolean}
     */
    validate: function() {
        var validation = this.model.validate(),
            errorsData = validation.errorsData,
            errors = [];

        // проверяем что валидируется не поле, а модель
        if (!validation.field && errorsData) {
            Object.keys(errorsData).sort(this.sortErrors.bind(this)).some(function(key) {
                this.highlightErrorField(key);

                return errorsData[key].some(function(error, index) {
                    // Всегда добавляем первое сообщение валидации и сообщения, помеченные required
                    (index == 0 || error.text.required) && errors.push(error.text);

                    // Заканчиваем добавлять ошибки, если в правиле есть флаг only
                    return error && error.text && error.text.only;
                });
            }, this);

            this._showErrors(errors);
            this._hasErrors = true;
        } else if (!validation.field && validation.valid) {
            this.clearErrorMessages();
        }

        return validation.valid;
    },

    /**
     * Отображает ошибки
     * @param {Array} errors
     * @returns {BEM}
     */
    _showErrors: function(errors) {
        BEM.DOM.update(
            this.elem('errors'),
            BEMHTML.apply(u._.unique(errors).map(function(error) {
                return error && {
                    block: 'b-strategy2-settings',
                    elem: 'error',
                    content: error.value || error
                };
            })));

        return this;
    },

    /**
     * Подсвечивает или снимает подсветку _error_yes с поля в зависимости от состояния
     * @param {String} field
     * @param {Boolean} [state=true]
     */
    highlightErrorField: function(field, state) {
        // nope
    },

    /**
     * Получение прогноза для автостратегий
     * переопределяется для модификатора type_cpm-auto
     * @private
     */
    _createForecast: function() {
        return;
    },

    /**
     * Определяет доступность дневного бюджета
     * @returns {Boolean}
     */
    isDayBudgetEnabled: function() {
        return false;
    },

    /**
     * Определяет доступность ограничения бюджета на показы в РСЯ
     * @returns {Boolean}
     */
    isContextLimitEnabled: function() {
        return false;
    },

    /**
     * Ограничение бюджета на показы в РСЯ (в процентах)
     * @returns {Number}
     */
    getContextLimit: function() {
        return 0;
    },

    /**
     * Параметр "Удерживать среднюю ставку ниже средней ставки на поиске"
     * @returns {Number}
     */
    getEnableCpcHold: function() {
        return 1;
    },

    /**
     * Параметр "Включен флаг оплата за конверсии"
     * @returns {boolean}
     */
    isCpaPayForConversionEnabled: function() {
        return false;
    },

    /**
     * Очищает сообщения об ошибках валидации
     * @returns {BEM}
     */
    clearErrorMessages: function() {
        if (this._hasErrors) {
            BEM.DOM.update(this.elem('errors'), '');
            this._hasErrors = false;
        }

        // ошибка о периоде кампании не должна пропадать после изменения модели для cpmAuto-стратегй
        this.model.hasField('cpmAuto') && this.model.get('cpmAuto') && this._checkCampaignPeriod();

        return this;
    },

    /**
     * Сортировка ошибок валидации
     * @abstract
     * @returns {number}
     */
    sortErrors: function() {
        return 1;
    },

    /**
     * Деструктор
     * @override;
     */
    destruct: function() {
        this._subscriptionManager.dispose();
        this.model.destruct();

        return this.__base.apply(this, arguments);
    },

    /**
     * Обработчик события изменения модели
     * @private
     */
    _onModelChange: function() {
        this.clearErrorMessages();
    },

    /**
     * Валидирует поле модели, подсвечивает его или снимает подсветку в зависимости от состояния,
     * зададает текст подсказки об ошибки, если он есть
     * @param {BEM} input - блок инпута, который необходимо валидировать
     * @returns {Boolean}
     */
    _validateField: function(input) {
        var hintBlock = this.findBlockOn(input.domElem, 'b-hintable'),
            val = input.val(),
            params = this.elemParams(this.elemify(input.domElem, 'prevalidate-input')),
            highValue = params.highValue,
            fieldValidationResult,
            isFieldValid,
            isHighValue,
            warnings;

        fieldValidationResult = this.model.validate(params.modelField);
        isFieldValid = (val === '') || !!fieldValidationResult.valid;
        isHighValue = isFieldValid && (val > highValue);
        // ошибочное поле
        input.toggleMod('error', 'yes', !isFieldValid);
        // поле с предупреждением
        input.toggleMod('warning', 'yes', isHighValue);

        if (!val) {
            warnings = '';
        } else if (!isFieldValid) {
            var errText = [];

            fieldValidationResult.errors.map(function(error) {
                errText.push(error.text.value || error.text);
            });

            warnings = errText.join('</br>');
        } else if (isHighValue) {
            warnings = iget2('b-strategy2-settings', 'obratite-vnimanie-zadano-vysokoe', 'Обратите внимание, задано высокое значение');
        }

        hintBlock.setHintContent(warnings);

        return fieldValidationResult;
    },

    /**
     * показывает/скрывает предупреждение метрики
     * Логика про особые поведения описана в тикете DIRECT-58935
     * https://st.yandex-team.ru/DIRECT-58935#1474973996000
     * @param {String} type - тип стратегии (у разных стратегий разное поведение)
     * @param {Object} metrikaWarning - предупреждения метрики
     * @param {String} metrikaWarning.text - текст предупреждения метрики
     * @private
     */
    _toggleMetrikaWarning: function(type, metrikaWarning) {
        if (type == 'wb') {
            var rmpWarning = this.model.get('rmpCountersWarning');
            this.setMod(this.elem('rmp-counters-warning'), 'visible', rmpWarning ? 'yes' : 'no');
        }
        this.setMod(this.elem('metrika-warning'), 'visible', metrikaWarning.text ? 'yes' : 'no');
    },

    /**
     * Обновляет интерфейс в зависимости от метрики
     * Логика про особые поведения описана в тикетах DIRECT-58935 и DIRECT-63262
     * https://st.yandex-team.ru/DIRECT-58935#1474973996000
     * https://st.yandex-team.ru/DIRECT-63262#1489770067000
     * @param {String} type - тип стратегии (у разных стратегий разное поведение)
     * @param {String} code - для всех стратегий дополнительно передается код предупреждения метрики
     * @param {Object} metrikaWarning - предупреждения метрики
     * @param {String} metrikaWarning.text - текст предупреждения метрики
     * @private
     */
    _toggleControls: function(type, code, metrikaWarning) {
        var isCPA = type == 'cpa' && code !== 'no-metrika',
            goals = this.model.get('metrika').campaign_goals,
            isOnlyCpaPayForConversion = type == 'cpa' && code === 'no-metrika' && goals.length === 0,
            isWeekBudget = type == 'wb',
            isDomainsCount = code == 'metrika-domains-count',
            isROI = type === 'roi' && code !== 'no-metrika';

        if (isCPA || isWeekBudget || isDomainsCount || isROI || isOnlyCpaPayForConversion) return;

        this.setMod(this.elem('row'), 'visible', metrikaWarning.text ? 'no' : 'yes');
    },

    /**
     * Обновление контролов в зависимости от предупреждений метрики
     * @param {String} type - тип стратегии (у разных стратегий разное поведение)
     * @param {String} code - код предупрждения
     * @private
     */
    _updateMetrika: function(type, code) {
        var metrikaWarning = this.model.get('metrikaWarning');

        this._toggleMetrikaWarning(type, metrikaWarning);
        this._toggleControls(type, code, metrikaWarning);
    },

    /**
     * Обновление текста предупреждения метрики
     * @param {Object} warning
     * @private
     */
    _updateMetrikaWarning: function(warning) {
        warning = warning || {};

        BEM.DOM.replace(
            this.findElem('metrika-warning'),
            BEMHTML.apply({
                block: 'b-strategy2-settings',
                elem: 'metrika-warning',
                elemMods: {
                    name: warning.code
                },
                text: warning.text,
                helpLinkUrl: this.model.get('helpLinkUrl')
            })
        );
    },

    /**
     * Обновление текста предупреждения счетчиков РМП
     * @param {String} warningText - текст предупреждения
     * @private
     */
    _updateRmpCountersWarning: function(warningText) {
        BEM.DOM.replace(
            this.findElem('rmp-counters-warning'),
            BEMHTML.apply({
                block: 'b-strategy2-settings',
                elem: 'rmp-counters-warning',
                text: warningText,
                helpLinkUrl: this.model.get('helpLinkUrl')
            })
        );
    },

    /**
     * Метод для отправки Ajax запроса
     * @returns {i-request_type_ajax|*} - jquery-request
     * @private
     */
    _request: function() {
        return BEM.create('i-request_type_ajax', {
            url: '/registered/main.pl',
            type: 'POST',
            cache: false,
            dataType: 'json',
            callbackCtx: this
        });
    },

    /**
     * Метод, инкапсулирующий запрос за целями счетчика Метрики
     * @param metrikaCounter {string} - номер счетчика метрики
     * @param cid {string | undefined} - id кампании
     * @returns {Jquery.Deferred} - deferred-объект, резолвящийся в полученные цели
     * @private
     */
    _requestMetrikaCounterForGoals: function(metrikaCounter, cid) {
        var deferred = $.Deferred(),
            params = {
                cmd: 'ajaxGetMetrikaGoalsByCounter',
                counter_id: metrikaCounter,
                ulogin: u.consts('ulogin')
            },
            request;

        if (cid) {
            params.cid = cid.toString();
        }

        request = this._request();

        request.get(
            params,
            function(res) {
                if (res.error || !res.available_goals) {
                    deferred.resolve([]);
                }
                request.destruct();
                deferred.resolve(res.available_goals);
            },
            function(err) {
                request.destruct();
                deferred.reject(err);
            },
            {
                method: 'POST'
            }
        );

        return deferred;
    },

    _fetchConversionsByGoalId: function() {
        var metrikaCounters = []; // счетчики кампании не используем, так как их могли удалить, а цели при этом остаются

        if (!u.strategy.isConversionsInfoAvailable(this.model.get('mediaType'))) {
            return;
        }

        u['b-strategy2-settings'].fetchConversionsByGoalId(metrikaCounters).then(function() {
            this.model.set('conversionsByGoalId', u['b-strategy2-settings'].getConversionsByGoalId());
            this._markConversions();
        }.bind(this));
    },

    _markConversions: function() {
        var conversionsByGoalId = u['b-strategy2-settings'].getConversionsByGoalId(),
            specialSelect = this.findBlockOn(this.elem('goal-select-special-control'), 'select'),
            conversionsAppendix;

        if (!specialSelect || !specialSelect._elemCache || !specialSelect._elemCache.control
          || !specialSelect._elemCache.control[0] || specialSelect._elemCache.control[0].length === 0) {
            return;
        }
        Array.from(specialSelect._elemCache.control[0]).map(function(option) {
            // специальные цели имеют Id < 1000 (все цели - 0, все КЦ - 13, и т.д)
            if (+option.getAttribute('conversionsMarked') || +option.value < 1000) {
                return;
            }
            var conversions = +conversionsByGoalId[option.value];

            if (conversionsByGoalId[option.value] === undefined) {
                conversionsAppendix = iget2('b-strategy2-settings', 'no-data', 'Нет данных');
            } else if (!conversions) {
                conversionsAppendix = iget2('b-strategy2-settings', 'no-conversions', 'Нет конверсий');
            } else if (conversions < 20) {
                conversionsAppendix = iget2('b-strategy2-settings', 'few-conversions', 'Мало конверсий');
            } else {
                conversionsAppendix = iget2('b-strategy2-settings', 'enough-conversions', 'Достаточно конверсий');
            }
            option.innerHTML += ' · ' + conversionsAppendix;
        });

        specialSelect.redraw();
    }
},
{
    /**
     *  Возвращает название модификатора блока настроек по идентификатору стратегии
     * @param {String} name – название (идентификатор стратегии)
     * @param {String} mediaType – тип кампании
     * @param {Object} _options – опции стратегии
     */
    getModNameByStrategyName: function(name, mediaType, _options) {
        var options = _options || {},
            goal_id = options.goal_id || (options.net || {}).goal_id || (options.search || {}).goal_id,
            // для трех типов стратегий avg-click/cpi/cpa используется один и тот же визуальный блок
            // https://st.yandex-team.ru/DIRECT-99183
            autobudgetMod = goal_id ?
                mediaType === 'mobile_content' ? 'cpi' : 'cpa' :
                'avg-click',
            names = {
            autobudget_avg_click: 'avg-click',
            autobudget_avg_cpa: 'cpa',
            autobudget_avg_cpi: 'cpi',
            autobudget_roi: 'roi',
            autobudget: autobudgetMod,
            autobudget_week_bundle: 'avg-click',
            autobudget_optimization_cpc: 'opt-cpc',
            autobudget_optimization_cpa: 'opt-cpa',
            maximum_clicks: 'max-clicks',
            search_maximum_coverage: 'search-maximum-coverage',
            cpm_default: 'cpm-default',
            autobudget_max_impressions: 'cpm-max-shows',
            autobudget_max_impressions_custom_period: 'cpm-max-shows',
            autobudget_max_reach: 'cpm-max-coverage',
            autobudget_max_reach_custom_period: 'cpm-max-coverage',
            autobudget_avg_cpv: 'avg-cpv',
            autobudget_avg_cpv_custom_period: 'avg-cpv',
        };

        return names[name];
    }
});

