var _conversionsByGoalId,
    _fetchPromise;

u.register({
    'b-strategy2-settings': {
        getConversionsByGoalId: function() {
            return _conversionsByGoalId;
        },
        fetchConversionsByGoalId: function(metrikaCounters) {
            var login = u.consts('ulogin'),
                queryExecutor = window && window.dna && window.dna.utils.getQueryExecutor(login),
                dataProvider = queryExecutor && queryExecutor.getConversionVisitsCountForCountersGoals.bind(queryExecutor);

            if (!_fetchPromise) {
                _fetchPromise = dataProvider && dataProvider(login, metrikaCounters).then(function(response) {
                    if (response.isMetrikaAvailable) {
                        _conversionsByGoalId = response.conversionsByGoalId;
                    }
                }.bind(this)).catch(function () {
                    // pass
                });
            }

            return _fetchPromise;
        }
    }
});
