/**
 * Модель панели настройки стратегии
 */
BEM.MODEL.decl({ model: 'b-strategy2-settings' }, {

    // название стратегии
    title: 'string',

    isCpaPayForConversionsStrategyAllowed: 'boolean',

    isCpaPayForConversionEnabled: {
        type: 'boolean',
        default: false
    },

    // Record<string, number> количество конверсий по целям
    conversionsByGoalId: {
        type: 'object',
        default: undefined
    },

    // идентификатор стратегии
    name: 'string',

    // валюта
    currency: 'string',

    // данные по целям Метрики
    metrika: 'object',

    /**
     * @property rmpCounters - данные по счетчикам РМП
     * @property {boolean} rmpCounters.allow_autobudget_avg_cpi – для подключения стратегии достаточно данных
     * @property {boolean} rmpCounters.cpi_deviation – количество установок приложения резко изменилось
     * @property {boolean} rmpCounters.decrease_setup – снизилось количество установок приложения
     * @property {boolean} rmpCounters.apps_count – количество приложений, используемых в компании > 1
     * @property {boolean} rmpCounters.setup_deviation – снизилось количество установок приложения
     */
    rmpCounters: 'object',

    // площадка стратегии
    where: {
        type: 'enum',
        enum: ['search', 'context']
    },

    // тип кампании
    mediaType: 'string',

    // отсутствуют ли цели Метрики
    disabledMetrika: {
        type: 'boolean',
        calculate: function() {
            return u['b-strategy2-settings'].isMetrikaDisabled(this.get('name'), this.get('metrika'), this.get('goalId'), this.get('where'), this.get('metrikaCounter'));
        }
    },

    // номер счетчика метрики
    metrikaCounter: 'string',

    goalSelectDisabled: {
        type: 'boolean',
        default: u.consts('failedToFetchMetrika')
    },

    attributionModel: {
        type: 'enum',
        enum: ['last_yandex_direct_click', 'last_significant_click', 'last_click', 'first_click']
    },

    // массив ключевых целей
    meaningfulGoals: 'array'

});


