block('b-time-targeting-holidays')(
    js()(true),

    content()(function() {
        var fromOptions = [],
            toOptions = [],
            levelOptions = [],
            data = this.ctx.data,
            level = data.holidaysTimeTargetLevel === undefined ?
                100 :
                data.holidaysTimeTargetLevel,
            holidays = (data.holidaysFrom !== undefined) && (data.holidaysTo !== undefined) ?
                [data.holidaysFrom, data.holidaysTo] :
                false,
            from = 8,
            to = 20,
            i,
            getFormattedHours = u['b-time-targeting'].getFormattedHours;

        if (Array.isArray(holidays)) {
            from = +holidays[0];
            to = +holidays[1];
        }

        for (i = 0; i <= 24; i++) {
            i < 24 && fromOptions.push({
                elem: 'option',
                attrs: {
                    value: i,
                    selected: from === i ? 'selected' : undefined
                },
                content: getFormattedHours(i)
            });

            i > from && toOptions.push({
                elem: 'option',
                attrs: {
                    value: i,
                    selected: to === i ? 'selected' : undefined
                },
                content: getFormattedHours(i)
            });
        }

        // Это коэффициенты ставок для выходных, их можно изменять в диапазоне от 10% до 200%
        for (i = 10; i <= 200; i += 10) {
            levelOptions.push({
                elem: 'option',
                attrs: {
                    value: i,
                    selected: level === i ? 'selected' : undefined
                },
                content: i + '%'
            });
        }

        return [
            data.showWorkingWeekendCheckbox && {
                elem: 'checkbox',
                elemMods: { type: 'intoAccountWeekend' },
                content: [
                    {
                        elem: 'checkbox-holder',
                        content: {
                            block: 'checkbox',
                            mods: {
                                theme: 'normal',
                                size: 's',
                                checked: data.intoAccountWeekend ? 'yes' : ''
                            },
                            mix: {
                                block: 'b-time-targeting-holidays',
                                elem: 'checkbox-control',
                                elemMods: { type: 'intoAccountWeekend' }
                            },
                            text: iget2('b-time-targeting-holidays', 'uchityvat-rabochie-vyhodnye', 'Учитывать рабочие выходные')
                        }
                    }
                ]
            },
            {
                elem: 'checkbox',
                elemMods: { type: 'intoAccountHolidays' },
                content: [
                    {
                        elem: 'checkbox-holder',
                        content: {
                            block: 'checkbox',
                            mods: {
                                theme: 'normal',
                                size: 's',
                                checked: data.intoAccountHolidays ? 'yes' : ''
                            },
                            mix: {
                                block: 'b-time-targeting-holidays',
                                elem: 'checkbox-control',
                                elemMods: { type: 'intoAccountHolidays' }
                            },
                            text: iget2('b-time-targeting-holidays', 'uchityvat-prazdnichnye-dni', 'Учитывать праздничные дни')
                        }
                    },
                    {
                        elem: 'holidays-controls',
                        elemMods: { hidden: data.intoAccountHolidays ? undefined : 'yes' },
                        content: [
                            {
                                block: 'radiobox',
                                mods: { theme: 'normal', size: 's' },
                                name: 'show',
                                value: data.dontShowOnHolidays ? 0 : 1,
                                mix: {
                                    block: 'b-time-targeting-holidays',
                                    elem: 'radiobox'
                                },
                                content: [
                                    {
                                        elem: 'radio',
                                        content: iget2('b-time-targeting-holidays', 'pokazyvat-s', 'показывать с'),
                                        controlAttrs: { value: 1 }
                                    },
                                    '<br>',
                                    {
                                        elem: 'radio',
                                        content: iget2('b-time-targeting-holidays', 'ne-pokazyvat', 'не показывать'),
                                        controlAttrs: { value: 0 }
                                    }
                                ]
                            },
                            {
                                elem: 'show-settings',
                                content: [
                                    {
                                        block: 'select',
                                        mods: {
                                            theme: 'normal',
                                            size: 's',
                                            name: 'from',
                                            disabled: data.dontShowOnHolidays ? 'yes' : undefined
                                        },
                                        js: { elemPopupMods: { 'small-content': 'yes' } },
                                        mix: {
                                            block: 'b-time-targeting-holidays',
                                            elem: 'select',
                                            elemMods: { type: 'from' }
                                        },
                                        content: [
                                            {
                                                block: 'button',
                                                mods: { theme: 'normal', size: 's' },
                                                content: getFormattedHours(from)
                                            },
                                            {
                                                elem: 'control',
                                                content: fromOptions
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'text',
                                        content: '&nbsp—&nbsp'
                                    },
                                    {
                                        block: 'select',
                                        mods: {
                                            theme: 'normal',
                                            size: 's',
                                            name: 'to',
                                            disabled: data.dontShowOnHolidays ? 'yes' : undefined
                                        },
                                        js: { elemPopupMods: { 'small-content': 'yes' } },
                                        mix: {
                                            block: 'b-time-targeting-holidays',
                                            elem: 'select',
                                            elemMods: { type: 'to' }
                                        },
                                        content: [
                                            {
                                                block: 'button',
                                                mods: { theme: 'normal', size: 's' },
                                                content: getFormattedHours(to)
                                            },
                                            {
                                                elem: 'control',
                                                content: toOptions
                                            }
                                        ]
                                    },
                                    {
                                        elem: 'text',
                                        elemMods: { type: 'level' },
                                        content: [iget2('b-time-targeting-holidays', 's-cenoy-klika', 'с ценой клика'), '&nbsp']
                                    },
                                    {
                                        block: 'select',
                                        mods: {
                                            theme: 'normal',
                                            size: 's',
                                            name: 'level',
                                            layout: 'content',
                                            disabled: data.dontShowOnHolidays ? 'yes' : undefined
                                        },
                                        mix: {
                                            block: 'b-time-targeting-holidays',
                                            elem: 'select',
                                            elemMods: { type: 'level' }
                                        },
                                        content: [
                                            {
                                                block: 'button',
                                                mods: { theme: 'normal', size: 's' },
                                                content: level
                                            },
                                            {
                                                elem: 'control',
                                                content: levelOptions
                                            }
                                        ]
                                    }
                                ]
                            }
                        ]
                    }
                ]
            }
        ];
    })
);
